#vertexshader

//varying vec4 pos;
varying vec3 normal;
varying vec4 color;
varying vec3 position;

void main()
{
	//pos = ftransform();
	//gl_Position = pos;
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	position.xyz = gl_Vertex.xyz;
//	gl_TexCoord[0] = gl_MultiTexCoord0;
	normal = gl_Normal;
	normal = gl_NormalMatrix * normal;
	color = gl_Color;
}

#fragmentshader

varying vec3 position;
varying vec3 normal;
varying vec4 color;
uniform sampler2D Texture0;
// pos (w = range)
uniform vec4 light;
uniform float intensity;

void main()
{
	vec3 dir = position - light.xyz;
	float lightlen = length(dir);
	dir = dir / lightlen;
	float value = (0.99 - (lightlen/light.w)*0.99) * intensity;
	float c = 0.01;
	if (value > 0.0)
		c = 0.01 + value;
	//vec3 cNorm = (dot(dir, normal)+0.5)/1.5 * color.xyz;

	//gl_FragColor = vec4(cNorm.x*c,cNorm.y*c,cNorm.z*c,1);
	gl_FragColor = vec4(color.x*c,color.y*c,color.z*c,1);
}
