struct PS_INPUT
{
  float2 Tex0: TEXCOORD0;
};

sampler base_map = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_InvScreenW : INVSCREENW;

float4 PS(PS_INPUT In) : COLOR0
{
  float4 color = tex2D(base_map, In.Tex0);
  color += tex2D(base_map, In.Tex0 + float2(V_InvScreenW * 1,0));
  color += tex2D(base_map, In.Tex0 - float2(V_InvScreenW * 1,0));
  color += tex2D(base_map, In.Tex0 + float2(V_InvScreenW * 2,0));
  color += tex2D(base_map, In.Tex0 - float2(V_InvScreenW * 2,0));
  color += tex2D(base_map, In.Tex0 + float2(V_InvScreenW * 3,0));
  color += tex2D(base_map, In.Tex0 - float2(V_InvScreenW * 3,0));
  color += tex2D(base_map, In.Tex0 + float2(V_InvScreenW * 4,0));
  color += tex2D(base_map, In.Tex0 - float2(V_InvScreenW * 4,0));
  color += tex2D(base_map, In.Tex0 + float2(V_InvScreenW * 5,0));
  color += tex2D(base_map, In.Tex0 - float2(V_InvScreenW * 5,0));
  color += tex2D(base_map, In.Tex0 + float2(V_InvScreenW * 6,0));
  color += tex2D(base_map, In.Tex0 - float2(V_InvScreenW * 6,0));
  color = color * 0.2;
  color = color.r * color.g * color.b / 2;
  
  return color;
}

technique Blur
{
  pass Blur
  {
    PixelShader = compile ps_2_0 PS();
  }
}
