struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_Time : TIME;
float V_Alpha : ALPHA;
float V_Var1 : VAR1; // Intens

float4 PS(VS_OUTPUT In) : COLOR0
{
  float a = (In.Tex0.x + (cos(V_Time * 1.67 + In.Tex0.y * 1.45 + 2.10) * 1.56 + cos(V_Time * 1.74 + In.Tex0.y * 1.39 + 1.87)) * V_Var1);
  float b = (In.Tex0.y + (cos(V_Time * 1.25 + In.Tex0.x * 1.31 + 0.65) * 2.01 + cos(V_Time * 1.45 + In.Tex0.x * 1.62 + 1.25)) * V_Var1);
  float4 color = tex2D(Sampler, frac(float2(a, b)));
  color.a     = V_Alpha * color.a;
  return color;
}

technique TechSin
{
  pass PassSin
  {
    VertexShader = null;
    PixelShader  = compile ps_2_0 PS();
  }
}
