/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Util3D;
import com.mascotcapsule.micro3d.v3.Vector3D;

public class MascotCamera
extends AffineTrans {
    private Vector3D pos;
    private Vector3D lookAt;
    private static final int divisor = 0x100000;

    public MascotCamera(Vector3D lookAtVector, Vector3D position) {
        this.lookAt = lookAtVector;
        this.calculateMatrix(this.lookAt);
        this.pos = position;
        this.generateMatrix();
    }

    private void generateMatrix() {
        AffineTrans posMatrix = new AffineTrans(1, 0, 0, this.pos.getX(), 0, 1, 0, this.pos.getY(), 0, 0, 1, this.pos.getZ());
        this.mul(posMatrix, this);
    }

    private void calculateMatrix(Vector3D lookAtVector) {
        Vector3D upVector = new Vector3D(0, 4096, 0);
        Vector3D rightVector = Vector3D.outerProduct(upVector, lookAtVector);
        upVector = Vector3D.outerProduct(lookAtVector, rightVector);
        int[] vec = new int[]{rightVector.getX(), upVector.getX(), lookAtVector.getX(), 0, rightVector.getY(), upVector.getY(), lookAtVector.getY(), 0, rightVector.getZ(), upVector.getZ(), lookAtVector.getZ(), 0};
        this.set(vec);
    }

    public void translateCamera(Vector3D lookAtVector, Vector3D position) {
        this.calculateMatrix(lookAtVector);
        this.pos = position;
        this.generateMatrix();
    }

    public Vector3D getPosition() {
        return new Vector3D(this.pos);
    }

    public Vector3D getLookAt() {
        return this.lookAt;
    }

    public static Vector3D calculateLookAt(int xRotation, int yRotation) {
        int r = Util3D.sin(yRotation);
        int x = -r * Util3D.sin(xRotation) / 0x100000;
        int y = Util3D.cos(yRotation) / 1024;
        int z = r * Util3D.cos(xRotation) / 0x100000;
        return new Vector3D(x, y, z);
    }
}

