/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Texture;
import com.mascotcapsule.micro3d.v3.Vector3D;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class EphScene
extends Effect {
    private static final int rotationIncrement = 10;
    private int COMMAND = 0x5001050;
    private int[] POINT = new int[]{0, 0, 0};
    private int[] textureCoords = new int[]{30, 30, 0, 0, 0, 16, 16, 0};
    private int[] NORMAL = new int[]{0, 0, 4096};
    private int[] colors = new int[]{0xFFFFFF};
    Texture particle;
    Figure terrain;
    Texture[] textures = new Texture[6];
    Figure skyBox;
    Texture envObjTex;
    Figure envObj;
    AffineTrans trans2;
    FigureLayout layout2;
    private static int currentFrame = 0;
    private Vector3D PARTICLE_POSITION = new Vector3D(0, -80, 1200);
    private Vector3D ROBOT_LOOK = new Vector3D(0, 0, -4096);
    private Vector3D ROBOT_UP = new Vector3D(0, 4096, 0);
    private int ROBOT_PERSPECTIVE = 512;
    private static int NUM_PARTICLES = 50;
    ObjectTransformation particleTrans;
    int rotationX = 100;
    int rotationY = 0;
    int translationZ = 0;
    int translationX = 0;
    FigureLayout particleLayout;
    Effect3D effect;
    Effect3D effect2;
    FigureLayout envLayout;
    MascotCamera mCamera;
    private Command changeCommand;
    private Command exitCommand;
    private Graphics3D cachedGraphics3D;
    Image[] bg = new Image[3];
    public static final int[][] particleXYZ = new int[NUM_PARTICLES][3];
    public int currentBackground = 0;
    public int backgroundTimer = 0;
    public int[] flashAt = new int[]{4000, 4500, 8000, 8500, 12000, 12500};
    public int flashCounter;

    public EphScene(DemoCanvas canvas) {
        super(canvas);
    }

    public void init(int[] timePoints) {
        int i;
        super.init(timePoints);
        try {
            for (i = 1; i < this.bg.length; ++i) {
                this.bg[i] = Image.createImage((String)("/moomin/eph-back" + i + ".png"));
            }
            this.particle = this.demo.loadTexture("/moomin/partikkelback.bmp", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.effect = new Effect3D();
        this.effect.setShadingType(0);
        this.effect.setTransparency(true);
        this.particleTrans = new ObjectTransformation();
        this.particleLayout = new FigureLayout();
        this.particleLayout.setPerspective(1, 4096, this.ROBOT_PERSPECTIVE);
        this.particleLayout.setCenter(70, 210);
        for (i = 0; i < particleXYZ.length; ++i) {
            EphScene.particleXYZ[i][0] = this.demo.rand.nextInt() % 24;
            EphScene.particleXYZ[i][1] = this.demo.rand.nextInt() % 24;
            EphScene.particleXYZ[i][2] = i * 1120 / NUM_PARTICLES - 1120;
        }
    }

    public void doLogic(int msPassed) {
        if (this.timePoints[this.currentAppearance + 1] - this.timeToLive > this.flashAt[this.flashCounter]) {
            this.backgroundTimer += msPassed;
            if (this.backgroundTimer > 600) {
                this.backgroundTimer = 0;
                this.currentBackground = 0;
                if (this.flashCounter < this.flashAt.length - 1) {
                    ++this.flashCounter;
                } else {
                    this.flashAt[this.flashCounter] = Integer.MAX_VALUE;
                }
            } else if (this.backgroundTimer > 500) {
                this.currentBackground = 1;
            } else if (this.backgroundTimer > 300) {
                this.currentBackground = 2;
            } else if (this.backgroundTimer > 200) {
                this.currentBackground = 1;
            }
        }
        this.translationZ += Math.max(msPassed / 8, 1);
        this.particleTrans.identity();
        this.particleTrans.setLookAt(this.PARTICLE_POSITION, this.ROBOT_LOOK, this.ROBOT_UP);
        this.particleLayout.setAffineTrans(this.particleTrans.calculateTransformation());
    }

    public void draw(Graphics g) {
        Graphics3D g3d = this.demo.getGraphics3D();
        g.drawImage(this.bg[this.currentBackground % 3], 0, 0, 20);
        try {
            g3d.bind(g);
            for (int i = 0; i < NUM_PARTICLES; ++i) {
                this.particleTrans.setTranslation(60 + particleXYZ[i][0], particleXYZ[i][1], (particleXYZ[i][2] + this.translationZ) % 1120);
                this.particleLayout.setAffineTrans(this.particleTrans.calculateTransformation());
                g3d.renderPrimitives(this.particle, 0, 0, this.particleLayout, this.effect, this.COMMAND, 1, this.POINT, this.NORMAL, this.textureCoords, this.colors);
            }
            g3d.flush();
            g3d.release(g);
        }
        catch (Throwable h) {
            h.printStackTrace();
        }
    }
}

