// Distortion. 10 is nice boom, 60 is glass brick
uniform float distort;
// Scale. 0.0-1.0
uniform float scale;
// Centerpoint for boom
uniform vec2 center;

uniform sampler2D Texture;

varying vec2 vTexCoord;

void main(void)
{
  vec2 coord = vTexCoord;

  vec2 v = coord-center;

  float len = v.x*v.x + v.y*v.y;

  v *= 1.0 - scale + sin(v*distort)*scale;

  coord = center+v;

  vec4 col = texture2D(Texture, coord);
  
  gl_FragColor = col;

}

