function fx_water_init()
{
	document.fx_water_w	= 64+8*0
	document.fx_water_h	= 48+6*0
	document.fx_water_imgDataIso	= buildBmp8Header( document.fx_water_w, document.fx_water_h )
	document.fx_water_Array			= []
	document.fx_water_tmpArray		= []

	var
		i,
		bottomLine = document.fx_water_w*document.fx_water_h

	for( i=-document.fx_water_w; i<bottomLine; i++ )
		document.fx_water_Array[ i ] = document.fx_water_tmpArray[ i ] = 0


	for( i=0;i<256;i++)
		document.fx_water_imgDataIso += byteToIsoArray[ Math.max(0,Math.min(255,i*5+64)) ]+ byteToIsoArray[ Math.max(0,Math.min(255,i*5-80)) ]+ byteToIsoArray[ Math.max(0,Math.min(255,i*5-128)) ]+"\0"

	progressBarIndex++
}

function fx_water_update( time, extraArguments )
{
	var
		i,
		w				= document.fx_water_w,
		h				= document.fx_water_h,
		imgDataIso		= document.fx_water_imgDataIso,
		bottomLine		= w*h,
		waterArray		= document.fx_water_Array,
		waterTmpArray	= document.fx_water_tmpArray


	if( mouse.hover )
		waterTmpArray[ Math.floor( mouse.x*w )+ Math.floor( mouse.y*h )*w ] = 127
	else
		waterTmpArray[ Math.floor( w/2+w/3*Math.cos( time/1280 ) )+ Math.floor( h/2+h/3*Math.sin( time/768 ) )*w ] = 127

	waterTmpArray[ Math.floor( Math.random()*bottomLine ) ] |= (time/51)&127

	var
		offsetRight	= bottomLine-1,
		offsetTop	= bottomLine-w,
		tmp			= bottomLine-w-1

	for( i=0; i<tmp; i++ )
		waterArray[ i ] = Math.max( 0,
			(
				waterTmpArray[ i+w ]+
				waterTmpArray[ (i+offsetRight)%bottomLine ]+
				waterTmpArray[ (i+offsetTop)%bottomLine ]+
				waterTmpArray[ i+1 ]
			)/2-waterArray[ i ] )&1023

	for( ; i<bottomLine; i++ )
		waterArray[ i ] = Math.max( 0,
			(
				waterTmpArray[ (i+w)%bottomLine ]+
				waterTmpArray[ (i+offsetRight)%bottomLine ]+
				waterTmpArray[ (i+offsetTop)%bottomLine ]+
				waterTmpArray[ (i+1)%bottomLine ]
			)/2-waterArray[ i ] )&1023


	for( i=0; i<tmp; i++ )
		imgDataIso += byteToIsoArray[ (waterArray[ i ]+waterArray[ i+1 ]+waterArray[ i+w ]+waterArray[ i+w+1 ])>>2 ]
	for( ; i<bottomLine; i++ )
		imgDataIso += byteToIsoArray[ (waterArray[ i ]+waterArray[ (i+1)%bottomLine ]+waterArray[ (i+w)%bottomLine ]+waterArray[ (i+w+1)%bottomLine ])>>2 ]


	document.fx_water_Array = waterTmpArray
	document.fx_water_tmpArray = waterArray

	customImageHandle.src	= imgDataIso
}