function fx_tunnel_init()
{
	w = document.fx_tunnel_w = 64+4
	h = document.fx_tunnel_h = 48+3

	var i,j,x,y,depth,angle,bottomLine,lastLine,imgDataIso
	//imgDataIso = buildBmp24Header( w, h )
	bottomLine = w*h

	// init document.fx_tunnel_tunnelArray
	document.fx_tunnel_tunnelArray 		= []
	document.fx_tunnel_tunnelAngleArray = []
	document.fx_tunnel_tunnelDepthArray = []
	document.fx_tunnel_tunnelJArray		= []
	var xTunnel,yTunnel

	for( i=0,y=0; y<=h; y++ )
	{
		for( x=0; x<w; x++ )
		{
			xTunnel	= x+.5-w/2
			yTunnel	= y+.5-h/2
			angle	= Math.floor( 128*Math.atan2( xTunnel, yTunnel )/Math.PI )&255
			j		= Math.floor( 256/(( xTunnel*xTunnel/w+ yTunnel*yTunnel/h ) ) )
			depth	= j&255

//			document.fx_tunnel_tunnelArray[ i ] 		= angle +(depth<<8)+(Math.min( 255,j )<<16)
			document.fx_tunnel_tunnelAngleArray[ i ]	= angle
			document.fx_tunnel_tunnelDepthArray[ i ]	= depth
			document.fx_tunnel_tunnelJArray[ i ]		= Math.min( 255,j )
			i++
		}
	}

	document.fx_tunnel_tunnelBmpHeader = 	buildBmp8Header( w, h )


	// init document.fx_tunnel_tunnelPalette
	document.fx_tunnel_tunnelPalette = []
	for( j=-128;j<128+128;j++)
	{
		i = Math.min( 127, Math.max( 0, j ) )
//		document.fx_tunnel_tunnelPalette[ j ] = byteToIsoArray[ Math.max(0,Math.min(255,i*8-256)) ]+ byteToIsoArray[ Math.max(0,Math.min(255,i*8-128)) ]+ byteToIsoArray[ Math.max(0,Math.min(255,i*8)) ]
		document.fx_tunnel_tunnelPalette[ j ] = byteToIsoArray[ Math.max(0,Math.min(255,i*4-32)) ]+ byteToIsoArray[ Math.max(0,Math.min(255,i*6-128)) ]+ byteToIsoArray[ Math.max(0,Math.min(255,i*8-192)) ]
		if( j>=0 )
			document.fx_tunnel_tunnelBmpHeader += "\0"+ document.fx_tunnel_tunnelPalette[ j ]
	}

	progressBarIndex++
}

function fx_tunnel_update( time, extraArguments )
{
	var	
		w					= document.fx_tunnel_w,
		h					= document.fx_tunnel_h,
//		tunnelArray			= document.fx_tunnel_tunnelArray,
//		tunnelPalette		= document.fx_tunnel_tunnelPalette,
		tunnelAngleArray	= document.fx_tunnel_tunnelAngleArray,
		tunnelDepthArray	= document.fx_tunnel_tunnelDepthArray,
		tunnelJArray    	= document.fx_tunnel_tunnelJArray,
		imgDataIso			= document.fx_tunnel_tunnelBmpHeader,
		bottomLine			= w*(h+1),
		xTunnel = Math.floor( -time/64 )&255,
		yTunnel = Math.floor( time/24 )&255,
		k = 20+18*Math.cos( time/512/2 ),
		lArray = []

	for( var i=0;i<256;i++)
		lArray[i+256] = lArray[i] = k*(1+Math.cos( 3*i/128*Math.PI ))
	
	for( i=bottomLine; --i; )
	{
		angle = tunnelAngleArray[ i ]
		depth = tunnelDepthArray[ i ]
		j = tunnelJArray[ i ]
		l = lArray[angle+xTunnel]

		imgDataIso += byteToIsoArray[ ( ((angle+xTunnel)^(depth+l+yTunnel) )&63)+127-(j+l)>>2 ]
	}

	customImageHandle.src	= imgDataIso
}