function fx_town_init( time, extraArguments )
{
	document.fx_town_buildingCount	= 5*3
	var
		buildingsHandle = document.createElement( 'DIV' )

	buildingsHandle.id = "buildings"
	buildingsHandle.style.display = "none"
	var bla = "<div id='buildingBase' style='background:#000;width:64em;height:48em;top:48em;left:0;position:absolute;'></div>"
	for( var buildingIndex=0; buildingIndex<document.fx_town_buildingCount; buildingIndex++ )
		bla += '<div id="building'+ buildingIndex +'" class="building"><hr class="building_left" /><hr class="building_right" /></div>'
	buildingsHandle.innerHTML = bla
	additionalNodesHandle.appendChild( buildingsHandle )

	document.fx_town_buildingHandleArray = []
	for( buildingIndex=0; buildingIndex<document.fx_town_buildingCount; buildingIndex++ )
		document.fx_town_buildingHandleArray[ buildingIndex ] = document.getElementById('building'+buildingIndex)


	progressBarIndex++
}


function fx_town_update( time, extraArguments )
{
	var
		buildingCount			= document.fx_town_buildingCount,
		buildingHandleArray		= document.fx_town_buildingHandleArray,
		an = time/1024,
		buildingIndex,
		cameraZ,
		c = Math.cos( an )*2,
		s = Math.sin( an )*2
		if( time<Math.PI/2*1536 )
			cameraZ = Math.abs( Math.sin(time/1536) )
		else
			cameraZ = Math.abs( 0.9+0.1*Math.sin(time/1536) )

	document.getElementById('buildings').style.display = ""

	renderAreaScaling = renderAreaHandle.offsetWidth/384

	document.getElementById('buildingBase').style.top		= Math.round( (432- 288*cameraZ )*renderAreaScaling )+"px"

	for( buildingIndex=0; buildingIndex<buildingCount; buildingIndex++ )
	{
		var
			i,
			X = ((buildingIndex*987^133)&127)-63,
			Y = ((buildingIndex*523^727)&127)-63,
			Z = ((buildingIndex*76^647)&31)*Math.cos(an+buildingIndex)*0+2*32+48,
			x = X*c+Y*s,
			y = X*s-Y*c+224,
			pt = [ [ x,y ], [ x+c,y+s ], [ x+c+s,y+s-c ], [ x+s,y-c ] ],
			xMin = xMax = pt[ 0 ][ 0 ],
			indexMin = indexMax = indexMid = 0


		for( i=1; i<4; i++ )
		{
			x= pt[ i ][ 0 ]
			if( x<xMin )
			{
				xMin = x
				indexMin = i
			}
			else if( x>xMax )
			{
				xMax = x
				indexMax = i
			}
		}
		for( i=1; i<4; i++ )
			if( i!=indexMin && i!=indexMax && pt[ i ][ 1 ]>pt[ indexMid ][ 1 ] )
				indexMid = i

		if( pt[ indexMid ][ 1 ]<0 )
		{
			buildingHandleArray[ buildingIndex ].style.display	= "none";
		}
		else
		{

			for( i=0; i<4; i++ )
			{
				persp = pt[ i ][ 1 ]/16
				pt[ i ][ 0 ] *= persp
				pt[ i ][ 1 ] = persp
			}

			// set the style
			w = Math.abs(pt[ indexMax ][ 0 ]-pt[ indexMin ][ 0 ])
			ratio = Z/8
			with( buildingHandleArray[ buildingIndex ].style )
			{
				display	= ""
				left	= Math.round( (192+pt[ indexMin ][ 0 ]/ratio)*renderAreaScaling ) +"px"
				top		= Math.round( (432- (288+ratio/2*pt[ indexMid ][ 1 ])*cameraZ)*renderAreaScaling ) +"px"
			}
			Z*=cameraZ
			with( buildingHandleArray[ buildingIndex ].firstChild.style )
			{
				borderTopWidth		= Math.round( Math.abs( pt[ indexMid ][ 1 ]-pt[ indexMin ][ 1 ])*Z*renderAreaScaling ) +"px"
				borderRightWidth	= Math.round( Math.abs( pt[ indexMid ][ 0 ]-pt[ indexMin ][ 0 ])*renderAreaScaling ) +"px"
			}
			with( buildingHandleArray[ buildingIndex ].lastChild.style )
			{
				borderTopWidth	= Math.round( Math.abs(pt[ indexMax ][ 1 ]-pt[ indexMid ][ 1 ])*Z*renderAreaScaling ) +"px"
				borderLeftWidth	= Math.round( Math.abs(pt[ indexMax ][ 0 ]-pt[ indexMid ][ 0 ])*renderAreaScaling ) +"px"
			}
		}
	}
}


function fx_town_destroy()
{
	document.getElementById('buildings').style.display = "none"
}

