
//============================================================================//
// O[oƒ萔

float4x4 g_mTIWorld;
float4x4 g_mWV;
float4x4 g_mWVP;
float3   g_vLight;
float3   g_vEye;
float4   g_cMaterial;
float4   g_cLight;
float4   g_cAmbient;
float2   g_vFogConst;

texture  g_tDecal;

//============================================================================//
// Tv`

sampler DecalSamp = sampler_state
{
	Texture = <g_tDecal>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = LINEAR;
};

sampler MirrorSamp = sampler_state
{
	Texture = <g_tDecal>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = LINEAR;
	AddressU  = MIRROR;
	AddressV  = MIRROR;
};

//============================================================================//




//============================================================================//
// eL[uʕ`(V[1)

struct RenderPlaneVS_Out
{
	float4 Pos : POSITION;
	float4 Col : COLOR;
	float3 N   : TEXCOORD0;
	float3 H   : TEXCOORD1;
};

RenderPlaneVS_Out RenderPlaneVS(
	float4 Pos : POSITION,
	float3 Nor : NORMAL
){
	RenderPlaneVS_Out Out;

	Out.Pos = mul( Pos, g_mWVP );
	Out.Col = g_cMaterial * ( g_cLight*abs(dot(Nor,g_vLight)) + g_cAmbient );
	Out.N   = Nor;
	Out.H   = g_vLight + (g_vEye-Pos);

	return Out;
}

float4 RenderPlanePS( RenderPlaneVS_Out In ) : COLOR
{
	// XyLvZ
	float3 H = normalize(In.H);
	float NH = abs(dot(In.N,H));

	NH = 1.5f * pow(NH,8);

	// XyLƊgU}[W
	// ̓}eAlg
	float4 Col;
	Col.rgb = In.Col + g_cLight*NH;
	Col.a   = g_cMaterial.a;
	return Col;
}

technique RenderPlane
{
	pass P0
	{
		VertexShader = compile vs_1_1 RenderPlaneVS();
		PixelShader  = compile ps_2_0 RenderPlanePS();

		ZEnable = False;
		AlphaBlendEnable = True;
		SrcBlend  = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
}

//============================================================================//









//============================================================================//
// eLXg`
//============================================================================//

struct RenderTextVS_Out
{
	float4 Pos : POSITION;
	float4 Col : COLOR;
	float3 N   : TEXCOORD0;
	float3 H   : TEXCOORD1;
	float  Fog : TEXCOORD2;
};

RenderTextVS_Out RenderTextVS(
	float4 Pos : POSITION,
	float3 Nor : NORMAL
){
	RenderTextVS_Out Out;

	float N  = mul( Nor, g_mTIWorld );
	float NL = max( dot(N,g_vLight), 0 );

	Out.Pos     = mul( Pos, g_mWVP );
	Out.Col.rgb = g_cMaterial * ( g_cLight*NL + g_cAmbient );
	Out.Col.a   = g_cMaterial.a;
	Out.N       = N;
	Out.H       = g_vLight + (g_vEye-Pos);

	// tHOp̌vZ
	float z = -mul( Pos, g_mWV ).z;
	Out.Fog = saturate( z * g_vFogConst.x + g_vFogConst.y );

	return Out;
}

float4 RenderTextPS( RenderTextVS_Out In ) : COLOR
{
	// XyLvZ
	float3 H = normalize(In.H);
	float NH = abs(dot(In.N,H));

	NH = 1.5f * pow(NH,8);

	// XyLƊgU}[W
	float4 Col = In.Col + g_cLight*NH;

	// tHO
	return In.Fog*Col;
}

technique RenderText
{
	pass P0
	{
		VertexShader = compile vs_1_1 RenderTextVS();
		PixelShader  = compile ps_2_0 RenderTextPS();
	}
}

//============================================================================//











//============================================================================//
// eL[uʕ`(V[2)

struct RenderCubeVS_Out
{
	float4 Pos : POSITION;
	float4 Col : COLOR;
	float3 N   : TEXCOORD0;
	float3 H   : TEXCOORD1;
	float2 Tex : TEXCOORD2;
	float  Fog : TEXCOORD3;
};

RenderCubeVS_Out RenderCubeVS(
	float4 Pos : POSITION,
	float3 Nor : NORMAL,
	float2 Tex : TEXCOORD
){
	RenderCubeVS_Out Out;

	float3 N   = mul( Nor, g_mTIWorld );
	float  NL  = max( dot(N,g_vLight), 0 );

	Out.Pos     = mul( Pos, g_mWVP );
	Out.Col.rgb = g_cMaterial * ( g_cLight*NL + g_cAmbient );
	Out.Col.a   = g_cMaterial.a;
	Out.N       = N;
	Out.H       = g_vLight + (g_vEye-Pos);
	Out.Tex     = Tex;

	// tHOp̌vZ
	float z = -mul( Pos, g_mWV ).z;
	Out.Fog = saturate( z * g_vFogConst.x + g_vFogConst.y );

	return Out;
}

float4 RenderCubePS( RenderCubeVS_Out In ) : COLOR
{
	// XyLvZ
	float3 H = normalize(In.H);
	float NH = max( dot(In.N,H), 0 );
	NH = 1.5f * pow(NH,8);

	// fBt[Y{XyL
	float4 Col = In.Col + g_cLight*NH;
	Col *= tex2D(DecalSamp,In.Tex);

	// tHO
	Col.a = In.Fog;
	return Col;
}

technique RenderCube
{
	pass P0
	{
		VertexShader = compile vs_1_1 RenderCubeVS();
		PixelShader  = compile ps_2_0 RenderCubePS();

		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
		ColorWriteEnable = Blue|Red|Green;
	}
}

//============================================================================//







//============================================================================//
// tA`(V[2)

struct RenderFlareVS_Out
{
	float4 Pos : POSITION;
	float4 Col : COLOR;
	float2 Tex : TEXCOORD0;
	float  Fog : TEXCOORD1;
};

RenderFlareVS_Out RenderFlareVS(
	float4 Pos : POSITION,
	float4 Col : COLOR,
	float2 Tex : TEXCOORD
){
	RenderFlareVS_Out Out;

	Out.Pos = mul( Pos, g_mWVP );
	Out.Col = Col;
	Out.Tex = Tex;

	// tHOp̌vZ
	float z = -mul( Pos, g_mWV ).z;
	Out.Fog = saturate( z * g_vFogConst.x + g_vFogConst.y );

	return Out;
}

float4 RenderFlarePS( RenderFlareVS_Out In ) : COLOR
{
	return In.Fog*In.Col*tex2D(DecalSamp,In.Tex);
}

technique RenderFlare
{
	pass P0
	{
		VertexShader = compile vs_1_1 RenderFlareVS();
		PixelShader  = compile ps_2_0 RenderFlarePS();

		ZWriteEnable = False;
		AlphaBlendEnable = True;
		SrcBlend  = SrcAlpha;
		DestBlend = One;
	}
}

//============================================================================//









//============================================================================//
// wi`p

float4 RenderMorphBGPS( float2 Tex : TEXCOORD ) : COLOR
{
	float4 Col;
	Col.rgb = tex2D(MirrorSamp,Tex);
	Col.a   = g_cMaterial.a;
	return Col;
}

technique RenderMorphBG
{
	pass P0
	{
		VertexShader = NULL;
		PixelShader  = compile ps_2_0 RenderMorphBGPS();

		ZEnable = False;
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
		ColorWriteEnable = BLUE|RED|GREEN;
	}
}

//============================================================================//

