
//============================================================================//
// O[oƒ萔

texture g_tPrev1;
texture g_tPrev2;
texture g_tHeight;

const float  Inc   = 1/256.0;
const float2 IncX  = { 1/256.0, 0       };
const float2 IncY  = { 0,       1/256.0 };
const float2 IncXY = { 1/256.0, 1/256.0 };

//============================================================================//
// Tv`

sampler Prev1Samp = sampler_state
{
	Texture = <g_tPrev1>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = POINT;
};

sampler Prev2Samp = sampler_state
{
	Texture = <g_tPrev2>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = POINT;
};

sampler HeightSamp = sampler_state
{
	Texture = <g_tHeight>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = POINT;
};

//============================================================================//
// ʍXV

float4 UpdateHeightPS( float4 Pos:POSITION, float2 Tex:TEXCOORD ) : COLOR
{
	float L = tex2D( Prev1Samp, Tex - IncX ).r;
	float R = tex2D( Prev1Samp, Tex + IncX ).r;
	float T = tex2D( Prev1Samp, Tex - IncY ).r;
	float B = tex2D( Prev1Samp, Tex + IncY ).r;
	float M = tex2D( Prev2Samp, Tex        ).r;
	return (L+R+T+B)/2 - M;
}

float4 UpdateNormalPS( float4 Pos:POSITION, float2 Tex:TEXCOORD ) : COLOR
{
	float dx = tex2D(HeightSamp,Tex+IncX).r - tex2D(HeightSamp,Tex-IncX).r;
	float dy = tex2D(HeightSamp,Tex+IncY).r - tex2D(HeightSamp,Tex-IncY).r;

	float4 Color;
	Color.rgb = 0.5*normalize(float3(dx,dy,4*Inc)) + 0.5;  // dz=dx/2
//	Color.rgb = 0.5*normalize(float3(dx,dy,2*Inc)) + 0.5;  // dz=dx=dy̏ꍇ
	Color.a   = 1.0f;
	return Color;
}

technique UpdateHeight
{
	pass P0
	{
		VertexShader = NULL;
		PixelShader  = compile ps_2_0 UpdateHeightPS();

		ZEnable = False;
		ZWriteEnable = False;
		CullMode = None;
		AlphaBlendEnable = False;
	}

	pass P1
	{
		VertexShader = NULL;
		PixelShader  = compile ps_2_0 UpdateNormalPS();

		ZEnable = False;
		ZWriteEnable = False;
		CullMode = None;
		AlphaBlendEnable = False;
	}
}

//============================================================================//

