/*
 * Decompiled with CFR 0.152.
 */
package file_resampler;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class firesa {
    private static final int EXPAND = 0;
    private static final int REDUCE = 1;
    private static final String VERSION = "1.0";

    private static byte[] SampleDown(byte[] data) {
        byte[] newdata = new byte[data.length / 2];
        int origcount = 0;
        int newcount = 0;
        while (origcount < data.length && newcount < newdata.length) {
            newdata[newcount] = (byte)((data[origcount] + data[origcount + 1]) / 2);
            ++newcount;
            origcount += 2;
        }
        return newdata;
    }

    private static byte[] SampleUp(byte[] data) {
        byte[] newdata = new byte[2 * data.length - 1];
        int origcount = 0;
        int newcount = 0;
        newdata[0] = data[0];
        while (origcount + 1 < data.length && newcount + 1 < newdata.length) {
            newdata[++newcount] = (byte)((data[origcount] + data[origcount + 1]) / 2);
            newdata[++newcount] = data[++origcount];
        }
        return newdata;
    }

    public static void main(String[] args) {
        System.out.println("FIleRESAmpler 1.0");
        System.out.println("FIleRESAmpler is distributed under the GNU General Public License, see Readme.txt for details");
        if (args.length < 3) {
            System.out.println("Syntax: firasa [x][r] <inputfile> <outputfile>x\tExpand filer\tReduce file");
            System.exit(-1);
        }
        int operation = -1;
        if (args[0].compareToIgnoreCase("x") == 0) {
            operation = 0;
        } else if (args[0].compareToIgnoreCase("r") == 0) {
            operation = 1;
        } else {
            System.err.print("Invalid operation: " + args[0]);
            System.exit(-1);
        }
        try {
            FileInputStream file = new FileInputStream(args[1]);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            int i = 0;
            while (i != -1) {
                i = file.read();
                bytes.write(i);
            }
            file.close();
            byte[] outdata = null;
            switch (operation) {
                case 0: {
                    outdata = firesa.SampleUp(bytes.toByteArray());
                    break;
                }
                case 1: {
                    outdata = firesa.SampleDown(bytes.toByteArray());
                }
            }
            FileOutputStream outfile = new FileOutputStream(args[2]);
            outfile.write(outdata);
            outfile.close();
        }
        catch (FileNotFoundException ex) {
            System.err.println("Error opening file: " + ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println("IO error: " + ex.getMessage());
        }
        System.out.println("Operation Complete");
    }
}

