#include "_shared.fx"

// texture
texture tBase;

// environment texture
texture tEnv;

// environment texture
texture tEnv2;

// world transform
matrix mWorld;

// vertex definition
//vertexshader vs = decl { fvf xyz | normal | tex1; };


struct VS_INPUT {
	float4	pos		: POSITION;
	float3	normal	: NORMAL;
	float2	uv		: TEXCOORD0;
};

struct VS_OUTPUT {
	float4	pos 	: POSITION;
	float2	uv		: TEXCOORD0;
};

struct VS_OUTPUT_ENV {
	float4	pos 	: POSITION;
	float2	uvEnv	: TEXCOORD0;
	float2	uv		: TEXCOORD1;
};

VS_OUTPUT vsMainf( VS_INPUT i, float f ) {
	VS_OUTPUT	o;

	//o.pos = mul( i.pos + float4( i.normal, 0 ) * f, mViewProj );

	o.pos = mul( i.pos + float4( i.normal, 0 ) * f, mWorld );
	o.pos = mul( o.pos, mViewProj );
	o.uv = i.uv;

	return o;
}

VS_OUTPUT vsMain1( VS_INPUT i ) { return vsMainf( i, 2.0 ); }
VS_OUTPUT vsMain2( VS_INPUT i ) { return vsMainf( i, 2.6 ); }
VS_OUTPUT vsMain3( VS_INPUT i ) { return vsMainf( i, 3.2 ); }


VS_OUTPUT_ENV vsMainEnv( VS_INPUT i ) {
	VS_OUTPUT_ENV	o;

	float3 normal = mul( i.normal, mWorld );
	normal = normalize( mul( normal, mSphereMap ) );
	o.uvEnv.x = normal.x;
	o.uvEnv.y = normal.y;
	o.pos = mul( i.pos + float4( i.normal, 0 ) * 3, mWorld );
	o.pos = mul( o.pos, mViewProj );
	o.uv = i.uv;

	return o;
}

VS_OUTPUT_ENV vsMain( VS_INPUT i ) {
	VS_OUTPUT_ENV	o;

	float3 normal = mul( i.normal, mWorld );
	normal = normalize( mul( normal, mSphereMap ) );
	o.uvEnv.x = normal.x;
	o.uvEnv.y = normal.y;
	o.pos = mul( i.pos, mWorld );
	o.pos = mul( o.pos, mViewProj );
	o.uv = i.uv;

	return o;
}


// Single pass
technique tec0
{
	pass P0
	{
		CullMode = CW;

		VertexShader = compile vs_1_1 vsMain();

		ZEnable = True;
		ZWriteEnable = True;

		AlphaBlendEnable = False;	

		Lighting = False;

		Texture[0] = <tEnv>;

		TexCoordIndex[0] = 0;
		TextureTransformFlags[0] = Disable;

		TextureFactor = 0xff000055;

		ColorOp[0]	 = Add;
		ColorArg1[0] = TFactor;
		ColorArg2[0] = Texture;
		
		ColorOp[1] = Disable;
	}

	pass P1
	{
		VertexShader = compile vs_1_1 vsMainEnv();

		CullMode = None;

		ZWriteEnable = False;

		Lighting = False;

		AlphaBlendEnable = True;	
		SrcBlend = SrcAlpha;
		DestBlend = One;

		Texture[0] = <tEnv2>;
		Texture[1] = <tBase>;

		TextureTransformFlags[0] = Disable;
		TextureTransformFlags[1] = Disable;
		TexCoordIndex[0] = 0;
		TexCoordIndex[1] = 1;
		
		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Texture;

		ColorOp[1]	 = Add;
		ColorArg1[1] = Current;
		ColorArg2[1] = Texture;
		AlphaOp[1]   = Add;
		AlphaArg1[1] = Current;
		AlphaArg2[1] = Texture;

		ColorOp[2] = Disable;
	}

	pass PLast
	{
		NormalizeNormals = false;

		VertexShader = NULL;

		ZWriteEnable = True;

		CullMode = CW;

		AlphaBlendEnable = False;	
	}
}
