float4x4 transform;
float4x4 transform2;
float4x4 worldTransform;
float4x4 projViewTransform;
float4x4 viewWorldTransform;
float4x4 blendTransform;
float4x4 blendTransform2;
float4 osViewPosition;
float4 osLightPosition;

struct output_t
{
  float4 position : POSITION;
  half2 texCoord : TEXCOORD0;
  half2 envCoord : TEXCOORD1;
  half3 lightVector : TEXCOORD4;
  half3 halfAngle : TEXCOORD5;
};

output_t main(float4 position : POSITION, half3 normal : NORMAL, 
			  half3 tangent : TANGENT, half2 texCoord : TEXCOORD0, float blendWeight : BLENDWEIGHT0, float blendWeight2 : BLENDWEIGHT1)
{
  output_t vsOut;

  // Compute vector to the light sources in object space
  float3 lightVector = normalize(osLightPosition - position);
  // Compute vector to the viewer in object space
  float3 eyeVector = normalize(osViewPosition - position);

  // Construct the tangent space matrix
  float3 binormal = cross(tangent, normal);
  float3x3 tsMatrix = float3x3(tangent, binormal, normal);

  float4 wsPosition = mul(worldTransform, position);
  //float4 blendPosition = blendWeight * mul(blendTransform, wsPosition);
  //blendPosition += blendWeight2 * mul(blendTransform2, wsPosition);
  
  float4 viewNormal = mul(viewWorldTransform, normal);
  normalize(viewNormal);
  
  float4 wsNormal = mul(worldTransform, normal);
  normalize(wsNormal);
  //float4 blendNormal = blendWeight * mul(blendTransform, wsNormal);
  //blendNormal += blendWeight2 * mul(blendTransform2, wsNormal);
  //normalize(blendNormal);

  // Fill the output structure
  vsOut.texCoord = texCoord;
  vsOut.envCoord = 0.5 * viewNormal + float2(0.5, 0.5f);
  vsOut.position = mul(projViewTransform, wsPosition);
  vsOut.lightVector = mul(tsMatrix, normalize(lightVector));
  vsOut.halfAngle = mul(tsMatrix, normalize(eyeVector + lightVector));

  return vsOut;
}
