/*  xa-003 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#include "../base/xio.h"
#include "../base/xdm.h"
#include "../gfx/gfx_cube.h"
#include "../gfx/gfx_plasma.h"
#include "../gfx/gfx_font.h"
#include "../gfx/gfx_noice.h"

namespace scene
{
	class RollingCube : public xdm::Scenebase {
	public:
		RollingCube(xio::Manager *i);
		virtual ~RollingCube() {};
		int draw(long time, float move);
	private:
		void drawBorder(int dx, int dy, int width, int height);
		gfx::Plasma gfx_plasma;
		std::map <int, gfx::Cube> gfx_cube;
		gfx::Font gfx_font;
		gfx::Noice gfx_noice;
		xio::surface *nsurface, *psurface;
	};
}
