/*  xa-003 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#ifndef SCENE_INTRO
#define SCENE_INTRO

#include "../base/xio.h"
#include "../base/xdm.h"
#include "../gfx/gfx_cube.h"
#include "../gfx/gfx_font.h"

namespace scene
{
	class Intro : public xdm::Scenebase {
	public:
		Intro(xio::Manager *i);
		virtual ~Intro() {};
		int draw(long time, float move);
	private:
		gfx::Font gfx_font;
		xio::surface *text_xa003, *text_ppres;
		//std::map <int, gfx::Cube> gfx_cube;
		xio::Random random;
	
		// Flowers
		std::map <int, xio::surface *> smallflower;
		struct bflower { int x, y; xio::surface *texture; };
		std::map <int, bflower> bflowerlist;
		/*std::map <int, xio::surface *> flower;
		std::map <int, xio::vector2d> flowercord;*/
	};
}

#endif
