/*  xa-003 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "scene_greets.h"
#include <cmath>
#include <iostream>
#include <sstream>

#ifdef WIN32
#include "SDL/SDL.h"
#else
#include "SDL.h"
#endif

using namespace std;

// Scene end time
#define END 51000 //47000+13000

namespace scene
{
	Greets::Greets(xio::Manager *i)
	{
		xio = i;	
		
		// Dance ---------------------------------------------------------------
		gfx_sort.init(i);
		gfx_sort.addObject(texture("midsommarstang"));
		gfx_sort.changeObject(0,
				320 - texture("midsommarstang")->w/2,
				480 - texture("midsommarstang")->h - 72 - 40);
		gfx_sort.addObject(texture("boy1"));
		gfx_sort.addObject(texture("boy2"));
		gfx_sort.addObject(texture("boy3"));
		gfx_sort.addObject(texture("boy4"));
		gfx_sort.addObject(texture("girl1"));
		gfx_sort.addObject(texture("girl2"));
		gfx_sort.addObject(texture("girl3"));
		gfx_sort.addObject(texture("girl4"));
		
		// For use in fadeout of last scene
		for(int i = 0; i < 5; i++)
			for(int j = 0; j < 5; j++)
				spart[i][j] = true;
		
		dance = xio->video->createSurface(640, 480);
			
		// City  ---------------------------------------------------------------
		// Build topsidewalk
		topsidewalk = xio->video->createSurface(640, 19);
		xio->video->fillSurfaceAll(topsidewalk, 0xff00ff);
		topsidewalk_warp = xio->video->createSurface(640, 19);
		for(int i = 0; i < 8; i++)
			xio->video->blit(texture("sidewalk1"), topsidewalk, texture("sidewalk1")->w*i, 0, 0, 0, -1, false);
				
		// Build bottomsidewalk
		bottomsidewalk = xio->video->createSurface(640, 100);
		xio->video->fillSurfaceAll(bottomsidewalk, 0xff00ff);
		bottomsidewalk_warp = xio->video->createSurface(640, 100);
		for(int i = 0; i < 7; i++)
			xio->video->blit(texture("sidewalk2_0"), bottomsidewalk, texture("sidewalk2_0")->w*i, 0, 0, 0, -1, false);
		

		// Build road
		road = xio->video->createSurface(640, 72);
		xio->video->fillSurfaceAll(road, 0xff00ff);
		road_warp = xio->video->createSurface(640, 72);
		
		for(int i = 0; i < 7; i++)
		{
			if(i == 0)
				xio->video->blit(texture("roadcrossing"), road, texture("roadcrossing")->w*i, 0, 0, 0, -1, false);
			else
				xio->video->blit(texture("road"), road, texture("road")->w*i, 0, 0, 0, -1, false);
		}
	}
	
	void Greets::drawCord(int x1, int y1, int x2, int y2)
	{
		/*double hl = fabs((float)x2-x1);
		double vl = fabs((float)y2-y1);
		double length = (hl>vl) ? hl : vl;
		float deltax = ((x2-x1) / (float)length);
		float deltay = ((y2-y1) / (float)length);
		
		for(int i = 0; i < (int)length; i++)
		{
			int x = (int)(x1 += (int)deltax);
			int y = (int)(y1 += (int)deltay);
			xio->video->setPixel(xio->video->getScreen(), x, y, 255, 255, 255);
		}*/
	}
	
	int Greets::draw(long time, float move)
	{				
		// Moveout dance and movein the city
		static float moveout = 0;
		EVENT(12000, 14500) //13000, 15500)
		{
			xio->video->fillScreenAll(0x5a5eff);
			
			if(moveout > -650) {
				moveout -= ((float)((float)(650/2))/25)*move;
				if(moveout < -650)
					moveout = -650;
			}
			for(int i = 0; i<15 ; i++)
				blit(texture("seperator"), 640+(int)moveout, texture("seperator")->h*i, 0, 0, -1, false);
		}
		
		// Dance
		EVENT(0, 14500)
		{
			static float xmove = 0, ymove = 0;
			xmove -= ((float)((float)(1))/25)*move;
			ymove -= ((float)((float)(1/10))/25)*move;
				
			// Clear screen
			xio->video->blit(texture("midsky"), dance, 0, 0, 0, 0, -1, false);
			EVENT(0, 12000)
			{
				gfx_sort.changeObject(1, 
					320 - gfx_sort.getTextureWidth(1)/2 + (int)(sin(xmove)*200),
					480 - gfx_sort.getTextureHeight(1) - 72 - 40 + (int)(cos(xmove)*30));
				
				gfx_sort.changeObject(2, 
					320 - gfx_sort.getTextureWidth(2)/2 + (int)(sin(xmove+1)*200),
					480 - gfx_sort.getTextureHeight(2) - 72 - 40 + (int)(cos(xmove+1)*30));
	
				gfx_sort.changeObject(3, 
					320 - gfx_sort.getTextureWidth(3)/2 + (int)(sin(xmove+2)*200),
					480 - gfx_sort.getTextureHeight(3) - 72 - 40 + (int)(cos(xmove+2)*30));
	
				gfx_sort.changeObject(4, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+3)*200),
					480 - gfx_sort.getTextureHeight(4) - 72 - 40 + (int)(cos(xmove+3)*30));
				
				gfx_sort.changeObject(5, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+4)*200),
					480 - gfx_sort.getTextureHeight(4) - 72 - 40 + (int)(cos(xmove+4)*30));
			
				gfx_sort.changeObject(6, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+5)*200),
					480 - gfx_sort.getTextureHeight(4) - 72 - 40 + (int)(cos(xmove+5)*30));
					
				gfx_sort.changeObject(7, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+6)*200),
					480 - gfx_sort.getTextureHeight(4) - 72 - 40 + (int)(cos(xmove+6)*30));
			
				gfx_sort.changeObject(8, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+7)*200),
					480 - gfx_sort.getTextureHeight(4) - 72 - 40 + (int)(cos(xmove+7)*30));
			}
			EVENT(12000, 13000)
				gfx_sort.setDraw(0, false);

			gfx_sort.blitObjects(dance);
			blit(dance, (int)moveout, 0, 0, 0, -1, false);
		}
		

		// Moving city and greets
		EVENT(12000, END) //42000)
		{
			EVENT(14500, END)
				xio->video->fillScreenAll(0x5a5eff);
			
			static float fout = 0;
			EVENT(38000, 42000) //EVENT(13000+38000, 13000+42000)
			{
				fout += (((float)1/4)/25)*move;
				if(fout > 1)
					fout = 1;
			}
			
			// House layer 1 (Tower)
			static float hl1 = 0;
			EVENT(12000, 27000)
			{
				EVENT(14000, 27000)
					hl1 -= ((float)((640+texture("houselayer1_1")->w)/12)/25)*move;
				blit(texture("houselayer1_1"), 650+640+(int)moveout+(int)hl1, 10+338-texture("houselayer1")->h, 0, 0, -1, false);
			}

			// House layer 2 (with "Globen")
			static float hl2_0 = 640;
			EVENT(12000, 13000+12000)
			{
				EVENT(14000, END)
					hl2_0 -= ((float)((640+texture("houselayer2_0")->w)/10)/25)*move;
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_0-640, 10+348-texture("houselayer2_0")->h, 0, 0, -1, false);
				blit(texture("houselayer2_1"), 650+(int)moveout+(int)hl2_0, 10+348-texture("houselayer2_1")->h, 0, 0, -1, false);
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_0+640, 10+348-texture("houselayer2_0")->h, 0, 0, -1, false);
			}
			
			// House layer 2 (without "Globen")
			static float hl2_1 = 640;
			EVENT(12000, 22000)
			{
				EVENT(14000, END)
					hl2_1 -= ((float)((640+texture("houselayer2_0")->w)/10)/25)*move;
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_1-640, 10+348-texture("houselayer2_0")->h, 0, 0, -1, false);
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_1, 10+348-texture("houselayer2_0")->h, 0, 0, -1, false);
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_1+640, 10+348-texture("houselayer2_0")->h, 0, 0, -1, false);
			}			
	
			// House layer 2 (without "Globen") (again)
			static float hl2_11 = 640;
			EVENT(22000, 32000)
			{
				hl2_11 -= ((float)((640+texture("houselayer2_0")->w)/10)/25)*move;
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_11-640, 10+348-texture("houselayer2_0")->h, 0, 0, -1, false);
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_11, 10+348-texture("houselayer2_0")->h, 0, 0, -1, false);
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_11+640, 10+348-texture("houselayer2_0")->h, 0, 0, -1, false);
			}		
			
			// House layer 2 (without "Globen") (again)
			static float hl2_12 = 640;
			EVENT(32000, 42000)
			{
				hl2_12 -= ((float)((640+texture("houselayer2_0")->w)/10)/25)*move;
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_12-640, 10+348-texture("houselayer2_0")->h, 0, 0, fout, false);
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_12, 10+348-texture("houselayer2_0")->h, 0, 0, fout, false);
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_12+640, 10+348-texture("houselayer2_0")->h, 0, 0, fout, false);
			}		

			// House layer 2 (without "Globen") (again)
			static float hl2_13 = 640;
			EVENT(13000+42000, END)
			{
				hl2_13 -= ((float)((640+texture("houselayer2_0")->w)/10)/25)*move;
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_13-640, 10+348-texture("houselayer2_0")->h, 0, 0, fout, false);
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_13, 10+348-texture("houselayer2_0")->h, 0, 0, fout, false);
				blit(texture("houselayer2_0"), 650+(int)moveout+(int)hl2_13+640, 10+348-texture("houselayer2_0")->h, 0, 0, fout, false);
			}		
			
			// House layer 3 ("Gamla stan")
			EVENT(12000, END)
			{
				static float hl3 = 0;
				EVENT(14000, END)
				{
					hl3 -= ((float)((640+texture("houselayer3")->w)/8)/25)*move;
					if(hl3 <= -texture("houselayer3")->w)
						hl3 = 0;
				}			
				blit(texture("houselayer3"), 650+(int)moveout+(int)hl3, 10+358-texture("houselayer3")->h, 0, 0, fout, false);
				blit(texture("houselayer3"), 650+(int)moveout+(int)hl3+640, 10+358-texture("houselayer3")->h, 0, 0, fout, false);
			}

			// House layer 4 (end)
			static float hl4 = 0;
			EVENT(38000, END)
			{
				blit(texture("houselayer4"), 650+(int)moveout+(int)hl4, 368-texture("houselayer4")->h, 0, 0, 1 - fout, false);
				blit(texture("houselayer4"), 650+(int)moveout+(int)hl4+640, 368-texture("houselayer4")->h, 0, 0, 1 - fout, false);
			}

			// Sidewalk1 layer (top sidewalk)
			static float sw1 = 0;
			EVENT(0, END)
			{
				EVENT(14000, 13000+42000)
				{
					sw1 -= ((float)((640)/2)/25)*move*(1-fout);
					if(sw1 <= -texture("sidewalk1")->w)
						sw1 = 0;
				}
				xio->video->warpSurface(topsidewalk, topsidewalk_warp, (int)sw1, 0);
				blit(topsidewalk_warp, 650+(int)moveout, 387 - topsidewalk_warp->h, 0, 0, -1, false);
			}

	
			// Road layer
			static float rl1 = 0;
			EVENT(0, END)
			{
				EVENT(14000, 13000+42000)
				{
					rl1 -= ((float)((640)/2)/25)*move*(1-fout);
					if(rl1 <= -640)//texture("road")->w*7)
						rl1 = 0;
				}
				xio->video->warpSurface(road, road_warp, (int)rl1, 0);
				blit(road_warp, 650+(int)moveout, 459 - road_warp->h, 0, 0, -1, false);
			}

			// Sidewalk2 layer
			static float sw2 = 0;
			EVENT(0, END)
			{
				EVENT(14000, 42000)
				{
					sw2 -= ((float)((640)/2)/25)*move*(1-fout);
					if(sw2 < -640)				
						sw2 = 0;
				}
			}
			xio->video->warpSurface(bottomsidewalk, bottomsidewalk_warp, (int)sw2, 0);
			blit(bottomsidewalk_warp, 650+(int)moveout, 480 - bottomsidewalk_warp->h, 0, 0, -1, false);	


			
			
		}
		// Driveby dance (and steal the midsommarstang :D)
		// and the drive in the city
		static float carx = -texture("xa-mobile-1")->w;
		static long ttime = time;
		static bool carimage = false;
		EVENT(11000, END)//13000)
		{
			if(time - ttime > 500) {
				if(carimage)
					carimage = false;
				else
					carimage = true;
				ttime = time;
			}
			
			EVENT(11000, 12000)
			{
				carx += ((float)((320 - texture("xa-mobile-1")->w/2))/25)*move*2;
				if(carx > 320 - texture("xa-mobile-1")->w/2)
					carx = 320 - texture("xa-mobile-1")->w/2;
			}
			
			EVENT(25500, 30000)
			{
				carx += ((float)((320))/25)*move;
				if(carx > 640 + texture("xa-mobile-1")->w)
					carx = 640 + texture("xa-mobile-1")->w;
			}
			
			EVENT(12000, END)//13000)
			{
				blit(texture("midsommarstang"), (int)carx + 25 + 10,
					480 - texture("midsommarstang")->h - 72 - 40,
					0, 0, -1, false);
			}
			
			if(carimage)
			{
				blit(texture("xa-mobile-1"),
						(int)carx,
						480-texture("xa-mobile-1")->h - 40,
						0, 0, -1, false);
			}
			else
			{
				blit(texture("xa-mobile-2"),
						(int)carx,
						480-texture("xa-mobile-2")->h - 40,
						0, 0, -1, false);
			}
		}
		
		// Greets
		EVENT(25500, END)
		{	
			EVENT(30000, 45000)
			{
				carx += ((float)(((float)(640)/2))/25)*move;
				if(carx > 640*7)
					carx = 640*7;
			}
			
			if(carimage)
				blit(texture("greets_greets1"), (int)carx-640,
						480-texture("greets_greets1")->h-40, 0, 0, -1, false);
			else				
				blit(texture("greets_greets2"), (int)carx-640,
						480-texture("greets_greets2")->h-40, 0, 0, -1, false);					
			
			if(carimage)
				blit(texture("greets_TJC2"), (int)carx-640*2,
						480-texture("greets_TJC2")->h-40, 0, 0, -1, false);
			else				
				blit(texture("greets_TJC1"), (int)carx-640*2,
						480-texture("greets_TJC1")->h-40, 0, 0, -1, false);

			if(carimage)
				blit(texture("greets_TMDCrew1"), (int)carx-640*3,
						480-texture("greets_TMDCrew1")->h-40, 0, 0, -1, false);
			else				
				blit(texture("greets_TMDCrew2"), (int)carx-640*3,
						480-texture("greets_TMDCrew2")->h-40, 0, 0, -1, false);	

			if(carimage)
				blit(texture("greets_odious2"), (int)carx-640*4,
						480-texture("greets_odious2")->h-40, 0, 0, -1, false);
			else				
				blit(texture("greets_odious1"), (int)carx-640*4,
						480-texture("greets_odious1")->h-40, 0, 0, -1, false);	
		
			if(carimage)
				blit(texture("greets_approximate1"), (int)carx-640*5,
						480-texture("greets_approximate1")->h-40, 0, 0, -1, false);
			else				
				blit(texture("greets_approximate2"), (int)carx-640*5,
						480-texture("greets_approximate2")->h-40, 0, 0, -1, false);
		
			if(carimage)
				blit(texture("greets_fairlight2"), (int)carx-640*6,
						480-texture("greets_fairlight2")->h-40, 0, 0, -1, false);
			else				
				blit(texture("greets_fairlight1"), (int)carx-640*6,
						480-texture("greets_fairlight1")->h-40, 0, 0, -1, false);	
		}


		static float ccx  = -texture("xa-mobile-1")->w;
		EVENT(43000, END)
		{
			ccx += ((float)(((float)(320-texture("xa-mobile-1")->w/2)/2))/25)*move;
			if(ccx > 320-texture("xa-mobile-1")->w/2)
				ccx = 320-texture("xa-mobile-1")->w/2;
			
			if(ccx == 320-texture("xa-mobile-1")->w/2)
				carimage = true;
			if(carimage)
			{
				blit(texture("xa-mobile-1"),
						(int)ccx,
						480-texture("xa-mobile-1")->h - 40,
						0, 0, -1, false);
			}
			else
			{
				blit(texture("xa-mobile-2"),
						(int)ccx,
						480-texture("xa-mobile-2")->h - 40,
						0, 0, -1, false);
			}			
			
			blit(texture("midsommarstang"), (int)ccx + 25 + 10,
					480 - texture("midsommarstang")->h - 72 - 40,
					0, 0, -1, false);
			
		}
		
		
		// If scenetime is out, end scene
		if(time >= END) 
		{
			// Save screen when we arrive at the END, we use it in the next scene.
			xio::surface *greetscreen = xio->video->createSurface(640, 480);
			xio->texture->add(greetscreen, "greetscreen");
			xio->video->blit(xio->video->getScreen(), texture("greetscreen"), 0, 0, 0, 0, -1, false);
			return 1;
		}
		return 0;
	}
}
