/*  xa-003 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "scene_end.h"
#include <cmath>
#include <iostream>
#include <sstream>

#ifdef WIN32
#include "SDL/SDL.h"
#else
#include "SDL.h"
#endif

using namespace std;

// Scene end time
#define END 18800+9000

namespace scene
{
	End::End(xio::Manager *i)
	{
		xio = i;
		gfx_font.init(i, texture("font"));		
		
		endtext = xio->video->createSurface(210, 480);
		//xio->video->fillSurface(endtext, 0x004400, 0, 0, endtext->w, endtext->h);
		xio->video->fillSurface(endtext, 0, 0, 0, endtext->w, endtext->h);
		
		textc = 0;
		
		addText("THE END");
		addText("");
		addText("Hope you liked it!");
		addText("");
		addText("Concept and code:");
		addText("- trejs");
		addText("- danter");
		addText("");
		addText("Graphics:");
		addText("- danter");
		addText("");
		addText("Music:");
		addText("- Jallabert/TJC");
		addText("");
		addText("This is our third demo");
		addText("and the second one at");
		addText("Remedy.");
		addText("");
		addText("Thanks for a great");
		addText("party,");
		addText("Remedy Scenezone 2004!");
		addText("");
		addText("xAngle");
		addText("http://xangle.cjb.net");
		addText("");
		addText("Btw,  All trademarks");
		addText("and registered");
		addText("trademarks are the");
		addText("property of their");
		addText("respective owners.");
		
		mainwindow = xio->video->createSurface(640, 480);
		
		gfx_sort.init(i);
		gfx_sort.addObject(texture("midsommarstang"));
		gfx_sort.changeObject(0,
				320 - texture("midsommarstang")->w/2,
				480 - texture("midsommarstang")->h - 40);
		gfx_sort.addObject(texture("boy1"));
		gfx_sort.addObject(texture("boy2"));
		gfx_sort.addObject(texture("boy3"));
		gfx_sort.addObject(texture("boy4"));
		gfx_sort.addObject(texture("girl1"));
		gfx_sort.addObject(texture("girl2"));
		gfx_sort.addObject(texture("girl3"));
		gfx_sort.addObject(texture("girl4"));
		gfx_sort.addObject(texture("boy5"));
	}
	
	void End::addText(const char *text)
	{
		gfx_font.draw(endtext, text, 5, 16*textc, 19/2, 32/2, -1, false);
		textc++;
	}
	
	int End::draw(long time, float move)
	{
		// Clear screen
		xio->video->fillScreenAll(0);//0x004400);

		
		// Shift last scene to the left
		static float moveout = 0;		
		EVENT(0, 2500)
		{
			//xio->video->fillScreenAll(0);
			
			if(moveout > -650) {
				moveout -= ((float)((float)(650))/25)*move*0.5;
				if(moveout < -650)
					moveout = -650;
			}
#ifndef NO_STEX
			blit(texture("greetscreen"), (int)moveout, 0, 0, 0, -1, false);
#endif
			for(int i = 0; i<15 ; i++)
				blit(texture("seperator"), 640+(int)moveout, texture("seperator")->h*i, 0, 0, -1, false);
		}
		
		static float moveup = 480;
		
		if(moveup > 0) {
			moveup -= ((float)((float)35/25))*move;
			if(moveup <= 0)
				moveup = 0;
		}
		
		static float xmove = 0, ymove = 0;
		
		xmove -= ((float)((float)(1))/25)*move;
		ymove -= ((float)((float)(1/10))/25)*move;
		
		xio->video->blit(texture("enddance"), mainwindow, 0, 0, 0, 0, -1, false);
				gfx_sort.changeObject(1, 
					320 - gfx_sort.getTextureWidth(1)/2 + (int)(sin(xmove)*200),
					480 - gfx_sort.getTextureHeight(1) - 40 + (int)(cos(xmove)*30));
				
				gfx_sort.changeObject(2, 
					320 - gfx_sort.getTextureWidth(2)/2 + (int)(sin(xmove+1)*200),
					480 - gfx_sort.getTextureHeight(2) - 40 + (int)(cos(xmove+1)*30));
	
				gfx_sort.changeObject(3, 
					320 - gfx_sort.getTextureWidth(3)/2 + (int)(sin(xmove+2)*200),
					480 - gfx_sort.getTextureHeight(3) - 40 + (int)(cos(xmove+2)*30));
	
				gfx_sort.changeObject(4, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+3)*200),
					480 - gfx_sort.getTextureHeight(4) - 40 + (int)(cos(xmove+3)*30));
				
				gfx_sort.changeObject(5, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+4)*200),
					480 - gfx_sort.getTextureHeight(4) - 40 + (int)(cos(xmove+4)*30));
			
				gfx_sort.changeObject(6, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+5)*200),
					480 - gfx_sort.getTextureHeight(4) - 40 + (int)(cos(xmove+5)*30));
					
				gfx_sort.changeObject(7, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+6)*200),
					480 - gfx_sort.getTextureHeight(4) - 40 + (int)(cos(xmove+6)*30));
			
				gfx_sort.changeObject(8, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+7)*200),
					480 - gfx_sort.getTextureHeight(4) - 40 + (int)(cos(xmove+7)*30));
					
				gfx_sort.changeObject(9, 
					320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+8)*200),
					480 - gfx_sort.getTextureHeight(4) - 40 + (int)(cos(xmove+8)*30));

		gfx_sort.blitObjects(mainwindow);
		
		blit(mainwindow, 650+(int)moveout, 0, 420, 480, -1, false);
	
		for(int i = 0; i<15 ; i++)
			blit(texture("seperator"), 650+(int)moveout+420, texture("seperator")->h*i, 0, 0, -1, false);
		blit(endtext, 650+(int)moveout+430, (int)moveup, 0, 0, -1, false);
						
		// If scenetime is out, end scene
		if(time >= END)
			return 1;
		return 0;
	}
}
