/*  Sorting blitter
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#ifndef GFX_SORT
#define GFX_SORT

#include <vector>

#include "../base/xio.h"

namespace gfx
{	
	class Sort {
	public:
		void init(xio::Manager *i);
		void addObject(xio::surface *texture);
		int getTextureWidth(int id) { return objects[id].texture->w; };
		int getTextureHeight(int id) { return objects[id].texture->h; };
		void changeObject(int id, int x, int y);
		void setDraw(int id, bool draw);
		void blitObjects(xio::surface *target);
	private:
		xio::Manager *xio;
		struct obdata {
			int x, y, c;
			bool draw;
			xio::surface *texture;
		};
		vector <obdata> objects;	
		static bool compare(const obdata &one, const obdata &two) { return one.c < two.c; };
	};
}
 
#endif
