/*  Plasma
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2003/2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#ifndef GFX_PLASMA
#define GFX_PLASMA

#include "../base/xio.h"

namespace gfx
{	
	class Plasma {
	public:
		~Plasma() { delete [] pr; delete [] pg; delete [] pb; };
		void draw(long time, int dx, int dy, float alpha);
		void init(xio::Manager *i, xio::surface *target);
	private:
		xio::Manager *xio;
		xio::surface *target;
		xio::u8 *map_red, *map_green, *map_blue, *pr, *pg, *pb;
	};	
}
 
#endif
