/*  Pixmap font reader
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "gfx_font.h"
#include <iostream>
#include <cmath>

using namespace std;

namespace gfx
{		
	void Font::init(xio::Manager *i, xio::surface *font)
	{
		xio = i;
		f = font;
		
		tempchar = xio->video->createSurface(19, 32);
	}

	void Font::draw(xio::surface *target, const char *text, int dx, int dy, int width, int height, float alpha, bool centralize)
	{			
		string stext = text;

		if(width > 0)
			charwidth = width; 
		else
			charwidth = 19;
		
		for(int i = 0; i < (int)stext.length(); i++)
		{
			// Clear temporary surface
			xio->video->fillSurface(tempchar, 0, 0, 0, 19, 32);
			
			// Draw to temporary surface
			for(int y = 0; y < 32; y++)
				for(int x = 0; x < 19; x++) {
					if(stext[i] != ' ') {
						xio->video->getPixel(f, &pixel, ((int)text[i]-33)*19+x, y);
						xio->video->setPixel(tempchar, x, y, pixel.r, pixel.g, pixel.b);
					}
					else
						xio->video->setPixel(tempchar, x, y, 255, 0, 255);
					
				}
			// Draw to target surface
			xio->video->blit(tempchar, target, dx+i*charwidth, dy, width, height, alpha, centralize);
		}	
	}
	
	xio::surface *Font::preDraw(const char *text)
	{
		string stext = text;
#ifdef DEBUG
		cout << "DEBUG | Predrawing text: \"" << stext.substr(0, 5) << "...\" ";
		cout.flush();
#endif
		xio::surface *outsurface = xio->video->createSurface(stext.length()*19, 32);
		xio->video->fillSurface(outsurface, 0xff00ff, 0, 0, stext.length()*19, 32);
		
		draw(outsurface, text, 0, 0, 0, 0, -1, false);
#ifdef DEBUG
		cout << "done." << endl;
#endif
		return outsurface;
	}
}
