/*  Animation runner
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#ifndef GFX_ANIM
#define GFX_ANIM

#include "../base/xio.h"

namespace gfx
{	
	class Anim {
	public:
		Anim() { addframec = 0; runframec = 0; };
		void init(xio::Manager *i, float frame_delay);
		void draw(xio::surface *target, float move, float alpha, bool centralize);
		void addFrame(const char *texture, float size, int x, int y);
	private:
		struct frame {
			xio::surface *texture;
			float size;
			int x, y;
		};
		map <int, frame> animation;
		int addframec;
		float runframec, delay, size, timediff;
		xio::Manager *xio;
	};	
}

#endif
