/*  xs - Support 
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
  
#ifndef XS_H
#define XS_H

#include <map>
#include <string>

namespace xs
{
	class WarningManager
	{
	public:
		WarningManager() {wc = -1; use_console = false; }
		void add(const char *msg);
		const char* get();
		void printToConsole(bool use) { use_console = use; };
	private:
		std::map<int, std::string> warning_list;
		int wc;
		bool use_console;
	};
	
	class MessageManager
	{
	public:
		MessageManager(const char *pretext) {mc = -1; use_console = false; ptext = pretext; }
		void add(const char *msg);
		const char* get();
		void printToConsole(bool use) { use_console = use; };
	private:
		std::map<int, std::string> message_list;
		int mc;
		bool use_console;
		std::string ptext;
	};
	
	
	class ShutdownManager
	{
	public:
		ShutdownManager() { qlist = -1; };
		void add(void (*func)(void));
		void run(int excode);
	private:
		std::map<int, void (*)()> shutdown_list;
		int qlist;
	};
	
	class ErrorManager
	{
	public:
		void add(const char *msg);
	};
	
	extern ErrorManager error;
	extern ShutdownManager shutdown;
	extern MessageManager message;
	extern MessageManager warning;
}
#endif
