/*  xdl - Demo launcher 
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef XDL_H
#define XDL_H

namespace xdl
{	
	struct config {
		bool fullscreen, sound;
		int freq;
		const char *window_title;
	};
	
	class Gui {
	public:
		Gui(int argc, char **argv, xdl::config *cfg);
		void show(const char *sidetext);
	private:
		// Callback casts
		static void cbSound(void *lparam) {
			((Gui*)lparam)->setSoundstatus();
		}
		static void cbWindow(void *lparam) {
			((Gui*)lparam)->setWindowstatus();
		}
		static void cbFreq22(void *lparam) {
			((Gui*)lparam)->setFreq22();
		}
		static void cbFreq32(void *lparam) {
			((Gui*)lparam)->setFreq32();
		}
		static void cbFreq44(void *lparam) {
			((Gui*)lparam)->setFreq44();
		}
		void setSoundstatus();
		void setWindowstatus();
		void setFreq22();
		void setFreq32();
		void setFreq44();
	};
}

#endif
