
float4x4 matWorldViewProj : register(c0);
float4x4 matWorld : register(c4);
float4x4 matWorldIT : register(c8);
float4 vEyeWS : register(c12);
float4 vLightWS1 : register(c13);
float4 vLightWS2 : register(c14);

struct VS_INPUT
{
    float4 vPosition : POSITION;
    float2 vTexCoord : TEXCOORD0;
    
    float3 vNormal : NORMAL;
    float3 vTangent : TANGENT;
    float3 vBinormal : BINORMAL;
};

struct VS_OUTPUT
{
	float4 vPosition : POSITION;
    float2 vTexCoord : TEXCOORD0;
    
    float3 vPositionWS : TEXCOORD7;
    float3 vNormalWS : TEXCOORD6;
    float3 vViewTS : TEXCOORD5;
    float3 vLightTS1 : TEXCOORD4;
    float3 vLightTS2 : TEXCOORD3;
    
    float3 vLightVecWS1 : TEXCOORD2;
    float3 vLightVecWS2 : TEXCOORD1;
};

VS_OUTPUT main(const VS_INPUT i)
{
	VS_OUTPUT o;
	
	// output position in clip-space
    o.vPosition = mul(i.vPosition, matWorldViewProj);
    
    // output texcoord
    o.vTexCoord = i.vTexCoord;
    
    // output position in world-space
    o.vPositionWS = mul(i.vPosition, matWorld);
    
    // compute world-space to tangent-space transformation
    float3x3 matWStoTS;
	matWStoTS[0] = mul(i.vTangent, matWorldIT);
	matWStoTS[1] = mul(i.vBinormal, matWorldIT);
	matWStoTS[2] = mul(i.vNormal, matWorldIT);
	
	// output normal vector in tangent-space
	o.vNormalWS = mul(i.vNormal, matWorldIT);
	
    // output light vector in tangent-space
    o.vViewTS = mul(matWStoTS, vEyeWS- o.vPositionWS);
    o.vLightTS1 = mul(matWStoTS, vLightWS1- o.vPositionWS);
    o.vLightTS2 = mul(matWStoTS, vLightWS2- o.vPositionWS);
    
    o.vLightVecWS1 = vLightWS1- o.vPositionWS;
    o.vLightVecWS2 = vLightWS2- o.vPositionWS;
    return (o);
}