float4x4 mWVP;
texture MatTexture;
float4 EyeVec;

sampler Samp = sampler_state
{
	Texture = <MatTexture>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float4 Col		:	COLOR;
	float2 Tex		:	TEXCOORD0;
	float3 Nrm		:	TEXCOORD1;
	float3 Eye		:	TEXCOORD2;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float3 Nor		:	NORMAL,
	float2 Tex		:	TEXCOORD
){
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
	Out.Tex = Tex;
	Out.Nrm = Nor;
	Out.Eye = normalize(EyeVec - Pos.xyz);
	return Out;
}

float4 PS( VS_OUTPUT In) : COLOR
{
	float4 amb = {0.25f,0.25f,0.25f,1.0f};
	float3 L = {-0.2f, -0.6f, -0.2f};
	float R  = -In.Eye + 2.0f*dot(In.Nrm,In.Eye)*In.Nrm;
	return tex2D(Samp, In.Tex) * (max(dot(In.Nrm,L),0) + amb) + pow(max(amb,dot(R,L)),8);
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_2_0 PS();
	}
}