::init
standalone 0
rttex rt
rttex rayorig
rttex raydir
rttex sso
rttex ssd
bbtex colors
rttex sso_arc
rttex ss_res
rttex snorm
rttex s_u
rttex s_v
loadshader shaders/tunnel/tunnel tunnel
loadshader shaders/tunnel/tunnel_ps_orig tunnel_ps_orig
loadshader shaders/tunnel/tunnel_colors tunnel_colors
loadshader shaders/bitmap/arctg arctg
loadshader shaders/sphere sphere_intersect
loadshader shaders/sphere_colors sphere_colors
loadshader shaders/shadow_dir shadow_dir
loadshader shaders/sph/sphere_pos sphere_pos
loadshader shaders/sph/sphere_norm sphere_norm
loadshader shaders/sph/sphere_prep_u sphere_prep_u
loadshader shaders/sph/sphere_texmap sphere_texmap
parameter lx,3
parameter ly,3
parameter lz,3
parameter ambr,3
parameter ambg,3
parameter ambb,3

::body
import bluetex
import spheretex
scene 1
cameraray rayorig,raydir
zclear rt
intersect rayorig,raydir,rt
_renderspheres rayorig,raydir,rt
_prepareshadows rayorig,raydir,rt,sso,ssd
shadowcast sso,ssd,ss_res
arctg sso,sso_arc
countcolors_tunnel rt,sso,ssd,sso_arc,colors,ss_res
_countspherecolors rayorig,raydir,rt,sso,ss_res,colors
output colors
scene 0

::shadowcast rayorig,raydir,rt
zclear rt
_renderspheres rayorig,raydir,rt  //


::intersect rayorig,raydir,rt
zbuf 1
setshader tunnel
settexture 0,rayorig
settexture 1,raydir
setconstant 2,64,1,0,0
commonvb2render rt

::_prepareshadows rayorig,raydir,rt,sso,ssd
// tunnel origin
settexture 0,rayorig
settexture 1,raydir
settexture 2,rt
getsurface sso,surf
setrendertarget surf
setshader tunnel_ps_orig
setconstant 2,64,1,0,0
commonvb2render
// sphere origin
settexture 1,rt
settexture 2,rayorig
settexture 3,raydir
setshader sphere_pos
preparesphereshadows
release surf
// ray dir - common
getsurface ssd,surf
setrendertarget surf
settexture 0,sso
setconstant 0,lx,ly,lz,0
setshader shadow_dir
commonvb2render
release surf

::countcolors_tunnel rt,sso,ssd,sso_arc,colors,ss_res
settexture 0,rt
settexture 1,sso
settexture 2,sso_arc
settexture 3,bluetex
settexture 4,ss_res
settexture 5,ssd
getsurface colors,surf
setrendertarget surf
setconstant 0,lx,ly,lz,0
setconstant 1,ambr,ambg,ambb,0
setshader tunnel_colors
commonvb2render
release surf

::arctg in,out
getsurface out,surf
setrendertarget surf
settexture 0,in
setshader arctg
commonvb2render
release surf

::_renderspheres rayorig,raydir,spheres_result
settexture 0,rayorig
settexture 1,raydir
getsurface spheres_result,sr_surf
setrendertarget sr_surf
setshader sphere_intersect
renderspheres
release sr_surf

::zclear rt
zbuf 1
getsurface rt,surf
setrendertarget surf
fullclear
release surf

// --------------
::_countspherecolors rayorig,raydir,spheres_result,sso,ss_res,dest
// calculate normals
setshader sphere_norm
getsurface snorm,dest_surf
setrendertarget dest_surf
settexture 0,spheres_result
settexture 3,sso
countspherecolors
release dest_surf
// calculate u,v
arctg snorm,s_v
getsurface s_u,surf
setrendertarget surf
setshader sphere_prep_u
settexture 0,snorm
commonvb2render
release surf
arct s_u,s_u
// map it
getsurface s_u,surf
setrendertarget surf
settexture 0,s_u
settexture 1,s_v
settexture 2,spheretex
setshader sphere_texmap
commonvb2render
release surf
//
setshader sphere_colors
getsurface dest,dest_surf
setrendertarget dest_surf
setconstant 0,lx,ly,lz,0
setconstant 2,ambr,ambg,ambb,0
settexture 0,spheres_result
settexture 3,s_u
settexture 5,ss_res
settexture 6,snorm
settexture 7,sso
countspherecolors
release dest_surf


::end
