float4x4 matWorldViewProj ;
float4x4 matWorld ;
float4 vecLightDir1 ;
float4 vecLightDir2 ;
float4 colAmbient ;
float4 colDiffuse1 ;
float4 colDiffuse2 ;
float4 vecEyePos ;
float3 vecOffset ;
float4 envMapBlendFactor ;
float4 v ;
texture tBase ;
texture tEnv ;

struct VS_OUTPUT
{
    	float4 Pos : POSITION;
    	float3 Norm : TEXCOORD0 ;
} ;

struct VS_OUTPUT_TEXTURED
{
	float4 Pos : POSITION ;
	float2 uv : TEXCOORD0 ;
	float3 Norm : TEXCOORD1 ;
} ;

struct VS_OUTPUT_TEXTURED_2STAGES
{

	float4 Pos : POSITION ;
	float2 uv : TEXCOORD0 ;
	float3 uvCube: TEXCOORD1 ;
	float3 Norm : TEXCOORD2 ;
} ;

sampler2D colorTextureSampler = sampler_state
{
	Texture = <tBase> ;
	MinFilter = Linear ;
	MagFilter = Linear ;
	MipFilter = Linear ;
};

samplerCUBE envTextureSampler = sampler_state
{
	Texture = <tEnv> ;
	MinFilter = Linear ;
	MagFilter = Linear ;
	MipFilter = Linear ;
} ;


VS_OUTPUT RenderSceneVS(float4 Pos : POSITION, float3 Normal : NORMAL)
{
    	VS_OUTPUT OUT ;
    
    	OUT.Pos = mul ( Pos , matWorldViewProj ) ;
   	OUT.Norm = normalize ( mul ( Normal , matWorld ) ) ;
   	
   	return OUT ;
}

VS_OUTPUT_TEXTURED RenderSceneTexturedVS ( float4 Pos : POSITION , float4 Normal : NORMAL , float2 uv : TEXCOORD0 ) 
{
	VS_OUTPUT_TEXTURED OUT ;
    
    	OUT.Pos = mul ( Pos , matWorldViewProj ) ;
   	OUT.Norm = normalize ( mul ( Normal , matWorld ) ) ;
   	OUT.uv = uv ;
   	
   	return OUT ;
}


float4 CubeMapLookup(float3 CubeTexcoord)
{
    	return texCUBE ( envTextureSampler , CubeTexcoord ) ;
}

float3 CalcReflectionVector ( float3 ViewToPos , float3 Normal )
{
    	return reflect ( ViewToPos, Normal ) ;
}

VS_OUTPUT_TEXTURED_2STAGES RenderSceneTextured2StagesEnvMapVS ( 
	float4 Pos : POSITION , 
	float3 Normal : NORMAL , 
	float2 uv : TEXCOORD0 ) 
{
	VS_OUTPUT_TEXTURED_2STAGES OUT ;
    
    	OUT.Pos = mul ( Pos , matWorldViewProj ) ;
   	OUT.Norm = normalize ( mul ( Normal , matWorld ) ) ;
   	OUT.uv = uv ;
   	
     	float3 n = normalize ( mul ( Normal , ( float3x3 ) matWorld ) ) ;
      	float3 EyeToVertex = normalize ( Pos - vecEyePos ) ;
  
    	OUT.uvCube = CalcReflectionVector ( EyeToVertex , n ) + vecOffset ;
   	
   	return OUT ;
}

float4 RenderScenePS ( float3 Norm : TEXCOORD0 ) : COLOR
{
    	return ( colAmbient + colDiffuse1 * saturate ( dot ( vecLightDir1 , Norm ) ) ) ;
}

float4 RenderScene2LightsPS ( float3 Norm : TEXCOORD0 ) : COLOR
{
    	float4 diffCol1 = ( colDiffuse1 * saturate ( dot ( vecLightDir1 , Norm ) ) ) ;
    	float4 diffCol2 = ( colDiffuse2 * saturate ( dot ( vecLightDir2 , Norm ) ) ) ;
    	float4 final = colAmbient + diffCol1 + diffCol2 ;
    	return final ;
}

float4 RenderSceneTexturedPS ( float2 uv : TEXCOORD0 , float3 Light : TEXCOORD1 , float3 Norm : TEXCOORD2 ) : COLOR
{
    	float4 diffCol = ( colAmbient + colDiffuse1 * saturate ( dot ( vecLightDir1 , Norm ) ) ) ;
    	float4 map = tex2D ( colorTextureSampler , uv ) ;
    	float4 final = ( diffCol * map ) ;
    	return final ;
}

float4 RenderSceneTextured2LightsPS ( float2 uv : TEXCOORD0 , float3 Light : TEXCOORD1 , float3 Norm : TEXCOORD2 ) : COLOR
{
    	float4 diffCol1 = ( colAmbient + colDiffuse1 * saturate ( dot ( vecLightDir1 , Norm ) ) ) ;
    	float4 diffCol2 = ( colAmbient + colDiffuse2 * saturate ( dot ( vecLightDir2 , Norm ) ) ) ;
    	float4 map = tex2D ( colorTextureSampler , uv ) ;
    	float4 final = ( diffCol1 * map + diffCol2 * map ) ;
    	return final ;
}

float4 RenderSceneTextured2LightsEnvMapPS ( VS_OUTPUT_TEXTURED_2STAGES IN ) : COLOR
{
    	float4 diffCol1 = ( colAmbient + colDiffuse1 * saturate ( dot ( vecLightDir1 , IN.Norm ) ) ) ;
    	float4 diffCol2 = ( colAmbient + colDiffuse2 * saturate ( dot ( vecLightDir2 , IN.Norm ) ) ) ;
    	float4 map = tex2D ( colorTextureSampler , IN.uv ) ;
    	float4 env = CubeMapLookup ( IN.uvCube ) ;
    	float4 final = ( diffCol1 * ( map ) + diffCol2 * ( map ) + env * envMapBlendFactor ) ;
    	return final ;
}

float4 RenderSceneTextured2LightsEnvMapInvertedPS ( VS_OUTPUT_TEXTURED_2STAGES IN ) : COLOR
{
	float4 white = { 1.0f , 1.0f , 1.0f , 1.0f } ;
    	float4 diffCol1 = ( colAmbient + colDiffuse1 * saturate ( dot ( vecLightDir1 , IN.Norm ) ) ) ;
    	float4 diffCol2 = ( colAmbient + colDiffuse2 * saturate ( dot ( vecLightDir2 , IN.Norm ) ) ) ;
    	float4 map = tex2D ( colorTextureSampler , IN.uv ) ;
    	float4 env = CubeMapLookup ( IN.uvCube ) ;
    	float4 final = ( diffCol1 * ( map ) + diffCol2 * ( map ) + env * envMapBlendFactor ) ;
    	return ( white - final ) ;
}

float4 RenderSceneInvertedPS(float3 Light: TEXCOORD0, float3 Norm : TEXCOORD1) : COLOR
{
	float4 white = { 1.0f , 1.0f , 1.0f , 1.0f } ;
   	float4 diffuse = { 1.0f, 0.0f, 0.0f, 1.0f};
    	float4 ambient = { 0.1, 0.0, 0.0, 1.0};
    	return white - ( colAmbient + colDiffuse1 * saturate ( dot ( vecLightDir1 , Norm ) ) ) ;
}

float4 RenderSceneTexturedInvertedPS ( float2 uv : TEXCOORD0 , float3 Light : TEXCOORD1 , float3 Norm : TEXCOORD2 ) : COLOR
{
	float4 white = { 1.0f , 1.0f , 1.0f , 1.0f } ;
    	float4 diffCol = colAmbient + colDiffuse1 * saturate ( dot ( vecLightDir1 , Norm ) ) ;
    	
    	float4 map = tex2D ( colorTextureSampler , uv ) ;
    	float4 final = diffCol * ( white - map ) ;
    	return final ;
}

technique RenderScene
{
    pass P0
    {          
        VertexShader = compile vs_1_1 RenderSceneVS () ;
        PixelShader  = compile ps_1_1 RenderScenePS () ;
    }
}

technique RenderSceneInverted
{
    pass P0
    {          
        VertexShader = compile vs_1_1 RenderSceneVS () ;
        PixelShader  = compile ps_1_1 RenderSceneInvertedPS () ;
    }
}

technique RenderScene2Lights
{
    pass P0
    {          
        VertexShader = compile vs_1_1 RenderSceneVS () ;
        PixelShader  = compile ps_1_1 RenderScene2LightsPS () ;
    }
}

technique RenderSceneTextured
{
    pass P0
    {          
        VertexShader = compile vs_1_1 RenderSceneTexturedVS () ;
        PixelShader  = compile ps_1_1 RenderSceneTexturedPS () ;
    }
}

technique RenderSceneTextured2Lights
{
    pass P0
    {          
        VertexShader = compile vs_1_1 RenderSceneTexturedVS () ;
        PixelShader  = compile ps_1_1 RenderSceneTextured2LightsPS () ;
    }
}

technique RenderSceneTextured2LightsEnvMap
{
    pass P0
    {          
        VertexShader = compile vs_1_1 RenderSceneTextured2StagesEnvMapVS () ;
        PixelShader  = compile ps_1_1 RenderSceneTextured2LightsEnvMapPS () ;
    }
}

technique RenderSceneTextured2LightsEnvMapInverted
{
    pass P0
    {          
        VertexShader = compile vs_1_1 RenderSceneTextured2StagesEnvMapVS () ;
        PixelShader  = compile ps_1_1 RenderSceneTextured2LightsEnvMapInvertedPS () ;
    }
}

technique RenderSceneTexturedInverted
{
    pass P0
    {          
        VertexShader = compile vs_1_1 RenderSceneTexturedVS () ;
        PixelShader  = compile ps_1_1 RenderSceneTexturedInvertedPS () ;
    }
}