#pragma once

typedef struct
{
	int a,b,c;
	float px,py,qx,qy,rx,ry;
	t3DVector n;
} tFace;

typedef struct
{
	int numPts;
	t3DVector *points;
} tPointSet;

#define vv virtual void

class tPrimitive
{
public:
	int NumVertices;
	int NumFaces;
	t3DVector *Vertices;
	t3DVector *VertexNormals;
	tFace *Faces;
	bool smooth;
	//tmxMatrix transform;

	~tPrimitive();
	vv Allocate();
	vv SetFace(int faceNum, int a, int b, int c, float px, float py, float qx, float qy, float rx, float ry);
	vv CalculateVertexNormals();

	vv Translate(float tx, float ty, float tz);
	vv Scale(float sx, float sy, float sz);
	vv Rotate(float rx, float ry, float rz);

	tPrimitive();
	vv Draw();
	vv TexDraw(float tilex, float tiley);
	vv Box(float wx, float wy, float wz);
	vv Grid(float wx, float wy, int segsx, int segsy);
	vv Sphere(float radius, int slices, int segments);

	vv Tube(float radius1, float radius2, float height, int slices);

	vv Lathe(tPointSet shape, int segs, bool close_surface);
	//vv Lathe2(tPointSet shape, float startangle, float endangle, int segs, bool close_surface);
	vv Loft(tPointSet shape, tPointSet path, bool close_shape, bool close_path);
};


void LoadMesh(tPrimitive *target, char filename[]);
void LoadCurve(tPointSet *target, char filename[]);
// planar UV mapping
void UVMap(tPrimitive *target);
