#include "project.h"

FSOUND_STREAM *ms_MusicStream;
//ULONG original_volume;

void Music_Init(char filename[])
{
	FILE *fp;
	unsigned long length;
	char *data;

	FSOUND_Init(44100, 32, 0);
	FSOUND_Stream_SetBufferSize(2000);

	fp = fopen(filename, "rb");

	if (fp==NULL)
	{
		MessageBox(NULL,"Error while loading music!","File not found",MB_OK);
		exit(1);
	}

	length=GetFileSize(filename);

	data = (char *)malloc(length);
	fread(data, length, 1, fp);
	fclose(fp);

	ms_MusicStream = FSOUND_Stream_OpenFile(data, FSOUND_NORMAL | FSOUND_MPEGACCURATE | FSOUND_LOADMEMORY, length);
}

void Music_Play(void)
{
	//waveOutGetVolume(0,&original_volume);
	FSOUND_Stream_Play(0,ms_MusicStream);
	//waveOutSetVolume( 0, 0xB332B332 );
}

void Music_Close(void)
{
	FSOUND_Close();
//#ifdef MUSIC_OFF
//	waveOutSetVolume(0, original_volume);
//#endif
}
