#include "project.h"

//tPrimitive asztallab,asztallap,asztalkeresztlec,asztallecek,gyertyatarto,mosogatocsesze,mosogatohatlap,csap;
//tPointSet gyertyatarto_crv,mosogatocsesze_crv;

tPrimitive asztal[10],mosogato[10],kocsog[2],konyha[15],sparhert[12],skybox,kisasztal[2],szek,legycsapo;
tPointSet asztal_crv[3],mosogato_crv[3],kocsog_crv[1],konyha_crv[1];

#define R2TSIZE 512

int r2ttex;
int fa1,fa2,rez,konyhako_tex,rozsda_tex,sp_rozsda_tex,sp_elolap_tex,fal_tex,sp_keret1,sutolap_tex,sp_ajtotex,sp_csotex,ko_tex,sky,lang;

float ambient[4]={0.5f,0.5f,0.5f,1};
float diffuse[4]={1,1,1,1};
float position[4]={0,0,10,1};

void konyha_init()
{
	// asztallab
	LoadMesh(&asztal[0],"data/asztallab.msh");
	UVMap(&asztal[0]);
	asztal[0].smooth=false;

	// asztallap
	LoadMesh(&asztal[1],"data/asztallap.msh");
	UVMap(&asztal[1]);
	asztal[1].Rotate(90,0,0);

	// keresztlec
	asztal[2].Box(3,0.5f,32);

	// gyertyatarto
	LoadCurve(&asztal_crv[0],"data/gyertyatarto.crv");
	asztal[3].Lathe(asztal_crv[0],12,false);

	// petroleumlampa bura
	LoadCurve(&asztal_crv[1],"data/petrlbura.crv");
	asztal[4].Lathe(asztal_crv[1],12,false);

	// petroleumlampa alja
	LoadCurve(&asztal_crv[2],"data/petrlalja.crv");
	asztal[5].Lathe(asztal_crv[2],12,false);

  // kanal
  /*LoadMesh(&asztal[6],"data/kanal.msh");
	UVMap(&asztal[6]);
  asztal[6].smooth=false;*/


  asztal[6].Tube(0.2f,0,2,8);

  LoadCurve(&asztal_crv[3],"data/tanyer.crv");
  asztal[7].Lathe(asztal_crv[3],12,false);

	


	// hatlap
	LoadMesh(&mosogato[0],"data/moshatlap.msh");
	UVMap(&mosogato[0]);

	// csesze
	LoadCurve(&mosogato_crv[0],"data/moscsesze.crv");
	mosogato[1].Lathe(mosogato_crv[0],12,false);
	mosogato[1].Translate(0,0,6);

	// vodor
	LoadCurve(&mosogato_crv[1],"data/vodor.crv");
	mosogato[2].Lathe(mosogato_crv[1],12,false);

	// cso
	mosogato[3].Tube(0.6f,0.5f,3,12);

	// csap
	LoadMesh(&mosogato[4],"data/csap.msh");
	mosogato[4].Translate(0,0,6.1f);



	// kocsog teste
	LoadCurve(&kocsog_crv[0],"data/kocsog.crv");
	kocsog[0].Lathe(kocsog_crv[0],16,false);



	// padlo
	konyha[0].Grid(85,85,10,10);
	konyha[0].smooth=false;
	konyha[0].Translate(0,1.5f,0);

	// szembefalak
	LoadMesh(&konyha[1],"data/szembefalak.msh");
	UVMap(&konyha[1]);
	konyha[1].smooth=false;

	// ajtofelfa
	LoadMesh(&konyha[2],"data/ajtofelfa.msh");
	UVMap(&konyha[2]);
	konyha[2].smooth=false;

	// oldalfal b
	LoadMesh(&konyha[3],"data/oldalfalb.msh");
	konyha[3].Translate(0,0,1.5);
	UVMap(&konyha[3]);
	konyha[3].smooth=false;

	// oldalfal j
	konyha[4].Grid(88,46,10,10);
	konyha[4].smooth=false;

	// korlatolt balfasz
	konyha[5].Grid(50,10,10,10);
	konyha[5].smooth=false;

	// korlatrudak
	LoadCurve(&konyha_crv[0],"data/korlatelem.crv");
	konyha[6].Lathe(konyha_crv[0],12,false);

	// korlatoltrger
	konyha[7].Box(30,2,5);
	konyha[7].smooth=false;

	// plafony
	konyha[8].Grid(80,88,10,10);
	konyha[8].smooth=false;

	// gerenda
	konyha[9].Box(76,10,5);
	//konyha[9].smooth=false;

	// kueszuab
	konyha[10].Box(24,0.8f,2.5f);

	// ajto2
	konyha[11].Box(22,33,3);
	konyha[11].smooth=false;

	// kilincs
	LoadMesh(&konyha[12],"data/kilincs.msh");
	//konyha[12].smooth=false;
	//konyha[12].Rotate(0,180,0);

	// ablakkeretek
	konyha[13].Box(4,0.5f,19);
	konyha[14].Box(4,25,0.5f);

	


	// lapja
	kisasztal[0].Box(5,1,10);

	// labai
	kisasztal[1].Tube(0.3f,0,10,12);

	


	// test
	LoadMesh(&sparhert[0],"data/sp_test.msh");
	UVMap(&sparhert[0]);

	// ajto1
	LoadMesh(&sparhert[1],"data/sp_ajto1.msh");
	UVMap(&sparhert[1]);
	sparhert[1].smooth=false;

	// ajto2
	LoadMesh(&sparhert[2],"data/sp_ajto2.msh");
	UVMap(&sparhert[2]);
	sparhert[2].smooth=false;

	// ajto3
	LoadMesh(&sparhert[3],"data/sp_ajto3.msh");
	UVMap(&sparhert[3]);
	sparhert[3].smooth=false;

	// kallantyu
	LoadMesh(&sparhert[4],"data/sp_kallantyu.msh");
	UVMap(&sparhert[4]);
	
	// teteje
	sparhert[5].Grid(5.6f,5.6f,10,10);
	sparhert[5].Rotate(-90,0,0);
	sparhert[5].Translate(0,9.2f,3.3f);

	// eleje
	sparhert[6].Grid(5.4f,8.4f,10,10);

	// nyito
	LoadMesh(&sparhert[7],"data/sp_nyito.msh");
	UVMap(&sparhert[7]);

	// cso1
	LoadMesh(&sparhert[8],"data/sp_cso1.msh");
	UVMap(&sparhert[8]);

	// cso2
	LoadMesh(&sparhert[9],"data/sp_cso2.msh");
	UVMap(&sparhert[9]);

	// cso3
	LoadMesh(&sparhert[10],"data/sp_cso3.msh");
	UVMap(&sparhert[10]);

	// cso4
	LoadMesh(&sparhert[11],"sp_cso4.msh");
	UVMap(&sparhert[11]);


	LoadMesh(&legycsapo,"data/legycsapo.msh");
	UVMap(&legycsapo);


	// skybox
	skybox.Sphere(100,12,12);
	for (int i=0; i<skybox.NumVertices; i++)
	{
		skybox.VertexNormals[i][0]*=-1;
		skybox.VertexNormals[i][1]*=-1;
		skybox.VertexNormals[i][2]*=-1;
	}




	glEnable(GL_TEXTURE_2D);
		fa1=JPG_UploadJPG3("data/fa1.jpg");
		fa2=JPG_UploadJPG3("data/fa2.jpg");
		rez=JPG_UploadJPG3("data/rez.jpg");
		konyhako_tex=JPG_UploadJPG3("data/konyhako.jpg");
		rozsda_tex=JPG_UploadJPG3("data/rozsda.jpg");
		sp_rozsda_tex=JPG_UploadJPG3("data/sp_rozsda.jpg");
		fal_tex=JPG_UploadJPG3("data/fal1.jpg");
		sp_keret1=JPG_UploadJPG3("data/sp_keret1.jpg");
		sp_elolap_tex=JPG_UploadJPG3("data/sp_elolap1.jpg");
		sutolap_tex=JPG_UploadJPG3("data/sutolap.jpg");
		sp_ajtotex=JPG_UploadJPG3("data/sp_ajto.jpg");
		sp_csotex=JPG_UploadJPG3("data/sp_cso.jpg");
		ko_tex=JPG_UploadJPG3("data/ko.jpg");
		sky=JPG_UploadJPG3("data/eg.jpg");
		lang=JPG_UploadJPG3("data/gyertyalang.jpg");
	glDisable(GL_TEXTURE_2D);

	glEnable(GL_LIGHT0);
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
	glLightfv(GL_LIGHT0, GL_POSITION, position);


	r2ttex=tx_CreateR2T(R2TSIZE);
	//do { jmunka(); }

}

void konyha_deinit()
{

}

void draw_asztal()
{
	glBindTexture(GL_TEXTURE_2D,fa2);
	glPushMatrix();
		glTranslatef(25,0,0);
		glTranslatef(0,10.5f,0);
		asztal[1].TexDraw(1,1);	
		glTranslatef(0,-10.5f,-15);
		asztal[0].TexDraw(1,1);
		glTranslatef(0,0,29);
		asztal[0].TexDraw(1,1);
		glTranslatef(0,4,-14);
		asztal[2].TexDraw(1,1);
		glTranslatef(4,6.5f,-2);
		glBindTexture(GL_TEXTURE_2D,rez);
		asztal[3].TexDraw(1,1);
    glTranslatef(-6,0,0);
    asztal[7].TexDraw(1,1);
    glTranslatef(6,3,0);
    glDisable(GL_TEXTURE_2D);
      asztal[6].Draw();
    glEnable(GL_TEXTURE_2D);
    
		//glTranslatef(0,0,4);
    /*glPushMatrix();
      glTranslatef(1,2,1);
      asztal[6].TexDraw(1,1);
    glPopMatrix();*/
    //asztal[7].TexDraw(1,1);

		//glDepthMask(false); glEnable(GL_BLEND); glBlendFunc(GL_SRC_ALPHA,GL_ONE); glColor4f(1,1,1,0.3f);
			//asztal[4].Draw();
		//glColor4f(1,1,1,1); glDisable(GL_BLEND); glDepthMask(true);

		//asztal[5].TexDraw(1,1);
	glPopMatrix();
}

void draw_mosogato()
{
	glBindTexture(GL_TEXTURE_2D,rez);
	glPushMatrix();
		glTranslatef(0,0,2);
		mosogato[2].TexDraw(1,1);
		glTranslatef(0,7,0);
		mosogato[3].TexDraw(1,1);

		glBindTexture(GL_TEXTURE_2D,rozsda_tex);
		glTranslatef(0,2.5f,-8);
		mosogato[0].TexDraw(1,1);
		mosogato[1].TexDraw(1,1);

		tx_BeginEnvMap();
			mosogato[4].Draw();
		tx_EndEnvMap();
	glPopMatrix();
}

void draw_sparhert()
{
	glEnable(GL_RESCALE_NORMAL);

	glPushMatrix();
		glTranslatef(13,0,40);
		glRotatef(180,0,1,0);

		glScalef(1.5f,1.5f,1.5f);

		glBindTexture(GL_TEXTURE_2D,sp_keret1);
		sparhert[0].TexDraw(1,1); // vaz
		glBindTexture(GL_TEXTURE_2D,sp_ajtotex);
		sparhert[1].TexDraw(1,1); // ajto1
		sparhert[2].TexDraw(1,1); // ajto2
		sparhert[3].TexDraw(1,1); // ajto3
		glBindTexture(GL_TEXTURE_2D,sp_ajtotex);
		sparhert[4].TexDraw(1,1); // kallantyu

		glBindTexture(GL_TEXTURE_2D,sutolap_tex);
		sparhert[5].TexDraw(1,1); // fedolap

		glPushMatrix();
		glBindTexture(GL_TEXTURE_2D,sp_csotex);
			glTranslatef(0,0,-2.5f);
			sparhert[8].TexDraw(1,1); // cso1
			sparhert[9].TexDraw(1,1); // cso2
			sparhert[10].TexDraw(1,1); // cso3
			sparhert[11].TexDraw(1,1); // cso4
		glPopMatrix();

		// oldalfalak
		glPushMatrix();
			glBindTexture(GL_TEXTURE_2D,sp_elolap_tex);
			glTranslatef(0,4.75f,6.45f);
			sparhert[6].TexDraw(1,1); // elolap
			glRotatef(90,0,1,0);
			glTranslatef(3.005f,0,3.0f);
			glBindTexture(GL_TEXTURE_2D,sp_rozsda_tex);
			sparhert[6].TexDraw(1,1); // jobb oldali
			glRotatef(180,0,1,0);
			glTranslatef(0,0,6.0f); // bal oldali
			sparhert[6].TexDraw(1,1);
		glPopMatrix();

		// nyitokak
		glPushMatrix();
			sparhert[7].Draw();
			glTranslatef(0,-1.9f,0);
			sparhert[7].Draw();
			glTranslatef(-1.2f,-2.2f,0);
			sparhert[7].Draw();
		glPopMatrix();
	glPopMatrix();

	glDisable(GL_RESCALE_NORMAL);
}

void draw_falak()
{
	glBindTexture(GL_TEXTURE_2D,konyhako_tex);

	// padlo
	glPushMatrix();
		glRotatef(-90,1,0,0);
		konyha[0].TexDraw(1,1);
	glPopMatrix();
	
	glBindTexture(GL_TEXTURE_2D,fal_tex);
	// szembefal
	glPushMatrix();
		konyha[1].TexDraw(1,1);
		glBindTexture(GL_TEXTURE_2D,ko_tex);
		konyha[2].TexDraw(1,1);

		glBindTexture(GL_TEXTURE_2D,fal_tex);
		glPushMatrix();
			//glTranslatef(0,23,0);
			glTranslatef(-37,0,0);
			glRotatef(90,0,1,0);
			konyha[3].TexDraw(1,1);
		glPopMatrix();


		glPushMatrix();
			glTranslatef(35,23,0);
			glRotatef(-90,0,1,0);
			konyha[4].TexDraw(1,1);
		glPopMatrix();

		glPushMatrix();
			glBindTexture(GL_TEXTURE_2D,fa1);
			glTranslatef(0,0,-53);
			glRotatef(-90,1,0,0);
			konyha[5].TexDraw(1,1); //talaj
		glPopMatrix();
		
		glPushMatrix();
			glTranslatef(-10,-0.9f,-53);
			konyha[6].TexDraw(1,1); // rudak
			glTranslatef(5,0,0);
			konyha[6].TexDraw(1,1);
			glTranslatef(5,0,0);
			konyha[6].TexDraw(1,1);
			glTranslatef(5,0,0);
			konyha[6].TexDraw(1,1);
			glTranslatef(5,0,0);
			konyha[6].TexDraw(1,1);
			glTranslatef(5,0,0);
			konyha[6].TexDraw(1,1);
			glTranslatef(5,0,0);
			konyha[6].TexDraw(1,1);
		glPopMatrix();

		glPushMatrix();
			glTranslatef(10,0,-53);
			konyha[7].TexDraw(1,1);
			glTranslatef(0,10,0);
			konyha[7].TexDraw(1,1); // getva
		glPopMatrix();

		glPushMatrix();
			glTranslatef(0,44,0);
			glRotatef(90,1,0,0);
			konyha[8].TexDraw(1,1);
		glPopMatrix();

		glPushMatrix();
			glTranslatef(0,42,-38.5f);
			konyha[9].TexDraw(1,1);
			glTranslatef(0,0,15);
			konyha[9].TexDraw(1,1);
			glTranslatef(0,0,15);
			konyha[9].TexDraw(1,1);
			glTranslatef(0,0,15);
			konyha[9].TexDraw(1,1);
			glTranslatef(0,0,15);
			konyha[9].TexDraw(1,1);
			glTranslatef(0,0,15);
			konyha[9].TexDraw(1,1);
		glPopMatrix();

		glBindTexture(GL_TEXTURE_2D,fa1);
		glPushMatrix();
			glTranslatef(10,0,-44.5f);
			konyha[10].TexDraw(1,1);
		glPopMatrix();

		glPushMatrix();
			glTranslatef(-8.5f,0,42);
			konyha[11].TexDraw(1,1);
		glPopMatrix();

		glBindTexture(GL_TEXTURE_2D,sp_csotex);
		tx_BeginEnvMap();
			glRotatef(180,0,1,0);
			glTranslatef(1,15,-38);
			konyha[12].TexDraw(1,1);
		tx_EndEnvMap();

		glBindTexture(GL_TEXTURE_2D,fa2);
		tx_BeginEnvMap();
			//glRotatef(180,0,1,0);
			glTranslatef(35,0,55);
			konyha[13].TexDraw(1,1);
			glTranslatef(0,25,0);
			konyha[13].TexDraw(1,1);
			glTranslatef(0,-12.5f,0);
			
			//glRotatef(90,1,0,0);
			glTranslatef(0,-12,-9.5f);
			konyha[14].TexDraw(1,1);
			glTranslatef(0,0,19);
			konyha[14].TexDraw(1,1);
		tx_EndEnvMap();
	glPopMatrix();
}

void draw_kisasztal()
{
	glPushMatrix();
		glTranslatef(-30,0,-15);
		glBindTexture(GL_TEXTURE_2D,fa2);
		glTranslatef(0,10,0);
		kisasztal[0].TexDraw(1,1);
		glTranslatef(2,-10,4.5f);
		kisasztal[1].TexDraw(1,1);
		glTranslatef(0,0,-9);
		kisasztal[1].TexDraw(1,1);
		glTranslatef(-4,0,0);
		kisasztal[1].TexDraw(1,1);
		glTranslatef(0,0,9);
		kisasztal[1].TexDraw(1,1);

		glBindTexture(GL_TEXTURE_2D,fa2);
		glTranslatef(1,10.75f,-5);
		glDepthMask(false); glEnable(GL_BLEND); glBlendFunc(GL_SRC_ALPHA,GL_ONE); glColor4f(1,1,1,0.3f);
			asztal[4].Draw();
		glColor4f(1,1,1,1); glDisable(GL_BLEND); glDepthMask(true);

		glBindTexture(GL_TEXTURE_2D,fa2);
		asztal[5].TexDraw(1,1);

	glPopMatrix();
}

/*

	/*glBindTexture(GL_TEXTURE_2D,r2ttex);
	glBegin(GL_QUADS);
		glTexCoord2f(0,0); glVertex2i(0,0);
		glTexCoord2f(0,1); glVertex2i(0,wm_height);
		glTexCoord2f(1,1); glVertex2i(wm_width,wm_height);
		glTexCoord2f(1,0); glVertex2i(wm_width,0);
	glEnd();*/

	//glDisable(GL_TEXTURE_2D);

	/*set2d(0,0,wm_width,wm_height);
	glDepthMask(false);
	glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);
		glColor4f(1,1,1,1-(sync%1000)/1000.0f);
			glBegin(GL_QUADS);
				glVertex2i(0,0);
				glVertex2i(0,wm_height);
				glVertex2i(wm_width,wm_height);
				glVertex2i(wm_width,0);
			glEnd();
		glColor4f(1,1,1,1);
	glDisable(GL_BLEND);
	glDepthMask(true);
	set3d(wm_fov,wm_width/(float)wm_height,wm_zNear,wm_zFar);*/

/*
15627 
15976
20922
21200
24358
24660
27818
28120
31324
31580
*/

void konyha_belenez(int sync)
{
	bool draw=false;
	set3d(wm_fov,wm_width/(float)wm_height,wm_zNear,wm_zFar);

	t3DVector eye,trg;
	/*
ping-ping... -||-
15627
?
20968
21247
24405
24707

27841
28120
31324
31650
  */

	if ((sync>=0) && (sync<5095))
	{
		draw=true;
		eye[0]=-25;
		eye[1]=20+(15-20)*(sync)/4800.0f;
		eye[2]=5+(-15-5)*(sync)/4800.0;
		trg[0]=-30;
		trg[1]=15;
		trg[2]=-5+(-25+5)*(sync)/4800.0f;

    if ((sync>=0) && (sync<150)) 
    {
      FadeIn(sync,150,1,1,1);
    }
    if ((sync>=279) && (sync<429))
    {
      FadeIn(sync-279,150,1,1,1);
    }
    /*if ((sync>=4500) && (sync<4800))
    {
      FadeOut(sync-4500,300,0,0,0);
    }*/
	}
	if ((sync>=5095) && (sync<8731))
	{
		draw=true;
		eye[0]=20+(15-30)*(sync-5095)/3636.0f;
		eye[1]=25+(20-25)*(sync-5095)/3636.0f;
		eye[2]=20;
		trg[0]=10;
		trg[1]=15;
		trg[2]=30;
    if ((sync>=5295) && (sync<5445))
    {
      FadeIn(sync-5295,150,1,1,1);
    }
    if ((sync>=5620) && (sync<5770))
    {
      FadeIn(sync-5620,150,1,1,1);
    }
    /*if ((sync>=8395) && (sync<8695))
    {
      FadeOut(sync-8395,300,1,1,1);
    }*/
    
	}
	if ((sync>=8731) && (sync<12191))
	{
		draw=true;
		eye[0]=30+(15-30)*(sync-8731)/3460.0f;
		eye[1]=10;//+(20-25)*(sync-8731)/3300.0f;
		eye[2]=15+(-20-15)*(sync-8731)/3460.0f;
		trg[0]=-15;
		trg[1]=5;
		trg[2]=-15;
    if ((sync>=8731) && (sync<8831))
    {
      FadeIn(sync-8731,150,1,1,1);
    }
    if ((sync>=9080) && (sync<9230))
    {
      FadeIn(sync-9080,150,1,1,1);
    }
    /*if ((sync>=11631) && (sync<11931))
    {
      FadeOut(sync-11631,300,1,1,1);
    }*/
	}
	if ((sync>=12191) && (sync<15697))
	{
		draw=true;
		eye[0]=20+(5-20)*(sync-12191)/3506.0f;
		eye[1]=30+(10-30)*(sync-12191)/3506.0f;
		eye[2]=15+(-10-15)*(sync-12191)/3506.0f;
		trg[0]=30;
		trg[1]=5;
		trg[2]=15+(-15-15)*(sync-12191)/3506.0f;
    if ((sync>=12191) && (sync<12341))
    {
      FadeIn(sync-12191,150,1,1,1);
    }
    if ((sync>=12493) && (sync<12643))
    {
      FadeIn(sync-12493,150,1,1,1);
    }
    /*if ((sync>=14891) && (sync<15191))
    {
      FadeOut(sync-14891,300,1,1,1);
    }*/
	}
	if ((sync>=15697) && (sync<18697))
	{
		draw=true;
		eye[0]=20+(-20-20)*(sync-15697)/3000.0f;
		eye[1]=30+(20-30)*(sync-15697)/3000.0f;
		eye[2]=40+(-25-40)*(sync-15697)/3000.0f;
		trg[0]=-25;
		trg[1]=15;
		trg[2]=-40;
    if ((sync>=15697) && (sync<15947))
    {
      FadeIn(sync-15697,150,1,1,1);
    }
    if ((sync>=16023) && (sync<16173))
    {
      FadeIn(sync-16023,150,1,1,1);
    }
    /*if ((sync>=18397) && (sync<18697))
    {
      FadeOut(sync-18397,300,1,1,1);
    }*/
	}
	

	if (draw)
	{
		glEnable(GL_TEXTURE_2D);
		gluLookAt(eye[0],eye[1],eye[2],trg[0],trg[1],trg[2],0,1,0);
	//glRotatef(7*my_sin(my_pi*2*(sync%5000)/5000.0f),0,0,1);

		glEnable(GL_LIGHTING); 

		glBindTexture(GL_TEXTURE_2D,sky);	
		skybox.TexDraw(7,7);

		glEnable(GL_CULL_FACE);
		glCullFace(GL_BACK);
			draw_sparhert();
			draw_falak();
			draw_asztal();
			glTranslatef(-25,0,-43);
			draw_mosogato();
			glTranslatef(25,0,43);
			draw_kisasztal();
		glDisable(GL_CULL_FACE);
		glDisable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);
	}
}

void konyha_repked(int sync)
{
  if (sync<13932)
  {
	  set3d(wm_fov,wm_width/(float)wm_height,wm_zNear,wm_zFar);

	  glEnable(GL_TEXTURE_2D);

	  tx_BeginR2T(R2TSIZE);
		  /*t3DVector eye = {20*my_sin(my_pi*2*(sync%5000)/5000.0f),
					  20+5*my_cos(my_pi*2*(sync%5000)/5000.0f),
					  15*my_cos(my_pi*2*(sync%5000)/5000.0f)};
		  t3DVector trg = {0,20,-5};
		  gluLookAt(	eye[0],eye[1],eye[2],trg[0],trg[1],trg[2],0,1,0);*/
		  t3DVector eye = {	20*my_sin(my_pi*2*(sync%6966)/6966.0f),
							          20+5*my_cos(my_pi*2*(sync%6966)/6966.0f),
							          15*my_cos(my_pi*2*(sync%6966)/6966.0f)};
		  t3DVector trg = {
                        0,//*my_cos(my_pi*2*(sync%6966)/6966.0f),
                        15+10*my_sin(my_pi*2*(sync%6966)/6966.0f),
                        -5*my_cos(my_pi*2*(sync%6966)/6966.0f)};
		  gluLookAt(eye[0],eye[1],eye[2],trg[0],trg[1],trg[2],0,1,0);

		  glRotatef(7*my_sin(my_pi*2*(sync%6966)/6966.0f),0,0,1);


		  glEnable(GL_LIGHTING); 

		  glBindTexture(GL_TEXTURE_2D,sky);	
		  skybox.TexDraw(7,7);

		  glEnable(GL_CULL_FACE);
		  glCullFace(GL_BACK);
			  draw_sparhert();
			  draw_falak();
			  draw_asztal();
			  glTranslatef(-25,0,-43);
			  draw_mosogato();
			  glTranslatef(25,0,43);
			  draw_kisasztal();
		  glDisable(GL_CULL_FACE);
		  glDisable(GL_LIGHTING);
		  tx_R2T(r2ttex,R2TSIZE);
	  tx_EndR2T(wm_width,wm_height);

	  set2d(0,wm_height,wm_width,0);
	  
	  glBindTexture(GL_TEXTURE_2D,r2ttex);
	  glBegin(GL_QUADS);
		  glTexCoord2f(0,0); glVertex2i(0,0);
		  glTexCoord2f(0,1); glVertex2i(0,wm_height);
		  glTexCoord2f(1,1); glVertex2i(wm_width,wm_height);
		  glTexCoord2f(1,0); glVertex2i(wm_width,0);
	  glEnd();

	  glDepthMask(false); glEnable(GL_BLEND); glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	  glColor4f(1,1,1,0.7f);


		  float xoffset1,yoffset1,xoffset2,yoffset2,xamp,yamp,xsines,ysines;
		  xamp=my_sin(2*my_pi*(sync%5000)/5000.0f);
		  yamp=my_sin(2*my_pi*(sync%3000)/3000.0f);
		  xsines=0.4f;
		  ysines=0.6f;
		  //float xoffset1,yoffset1,xoffset2,yoffset2;
		  //float angle = -my_pi*0.25*((sync%5000)/5000.0f);

		  glBegin(GL_QUADS);
			  for (int j=0; j<(wm_width/10); j++)
				  for (int i=0; i<(wm_width/10); i++)
				  {
					  xoffset1=xamp*my_sin(2*my_pi*xsines*i/(wm_width/10.0f));
					  yoffset1=yamp*my_sin(2*my_pi*ysines*j/(wm_width/10.0f));
					  xoffset2=xamp*my_sin(2*my_pi*xsines*(i+1)/(wm_width/10.0f));
					  yoffset2=yamp*my_sin(2*my_pi*ysines*(j+1)/(wm_width/10.0f));
					  //xoffset1=0;
					  //yoffset1=0;
					  //xoffset2=my_cos(angle);
					  //yoffset2=my_sin(angle);

					  glTexCoord2f(xoffset1+(float)i/(wm_width/10.0f),    yoffset1+(float)j/(wm_width/10.0f)    );glVertex2i(wm_width*i/(wm_width/10),	 wm_height*j/(wm_width/10));
					  glTexCoord2f(xoffset1+(float)i/(wm_width/10.0f),    yoffset2+(float)(j+1)/(wm_width/10.0f));glVertex2i(wm_width*i/(wm_width/10),	 wm_height*(j+1)/(wm_width/10));
					  glTexCoord2f(xoffset2+(float)(i+1)/(wm_width/10.0f),yoffset2+(float)(j+1)/(wm_width/10.0f));glVertex2i(wm_width*(i+1)/(wm_width/10), wm_height*(j+1)/(wm_width/10));
					  glTexCoord2f(xoffset2+(float)(i+1)/(wm_width/10.0f),yoffset1+(float)j/(wm_width/10.0f)    );glVertex2i(wm_width*(i+1)/(wm_width/10), wm_height*j/(wm_width/10));
				  }
		  glEnd();
		  glColor4f(1,1,1,1);

	  glDisable(GL_BLEND); glDepthMask(true);
	  glDisable(GL_TEXTURE_2D);

    if (sync>=12432)
    {
      FadeOut(sync-12432,1500,1,1,1);
    }
  }
}

typedef t3DVector bezier[4];

void konyha_legycsapo(int sync)
{
  if (sync>=3950)
	{
		set3d(90,wm_width/(float)wm_height,wm_zNear,wm_zFar);

		if ((sync>=3950) && (sync<4950))
		{
			t3DVector eye = {	10+(-15-10)*(sync-3950)/1000.0f,
								-15+(25+15)*(sync-3950)/1000.0f,
								5+(-15-5)*(sync-3950)/1000.0f};
			t3DVector trg = {0,0,0};
			gluLookAt(eye[0],eye[1],eye[2],trg[0],trg[1],trg[2],0,1,0);
		}
		if ((sync>=5670) && (sync<6670))
		{
			t3DVector eye = {	-10+(15-10)*(sync-5670)/1000.0f,
								-15+(25-(-15))*(sync-5670)/1000.0f,
								5+(-15-5)*(sync-5670)/1000.0f};
			t3DVector trg = {0,0,0};
			gluLookAt(eye[0],eye[1],eye[2],trg[0],trg[1],trg[2],0,1,0);
		}
		if ((sync>=7350) && (sync<8370))
		{
			t3DVector eye = {	-10+(15-10)*(sync-7350)/1000.0f,
								10+(-25-10)*(sync-7350)/1000.0f,
								5+(-15-5)*(sync-7350)/1000.0f};
			t3DVector trg = {0,0,0};
			gluLookAt(eye[0],eye[1],eye[2],trg[0],trg[1],trg[2],0,1,0);
		}
		if ((sync>=9000) && (sync<10000))
		{
			t3DVector eye = {	10+(-15-10)*(sync-9000)/1000.0f,
								15+(10-15)*(sync-9000)/1000.0f,
								5+(-15-5)*(sync-9000)/1000.0f};
			t3DVector trg = {0,0,0};
			gluLookAt(eye[0],eye[1],eye[2],trg[0],trg[1],trg[2],0,1,0);
		}
		if ((sync>=10650) && (sync<11650))
		{
			t3DVector eye = {	-10+(15-10)*(sync-10650)/1000.0f,
								10+(-10-10)*(sync-10650)/1000.0f,
								5+(-15-5)*(sync-10650)/1000.0f};
			t3DVector trg = {0,0,0};
			gluLookAt(eye[0],eye[1],eye[2],trg[0],trg[1],trg[2],0,1,0);
		}
		if ((sync>=12350) && (sync<13350))
		{
			t3DVector eye = {	10+(-15-10)*(sync-12350)/1000.0f,
								15+(-5+15)*(sync-12350)/1000.0f,
								5+(-15-5)*(sync-12350)/1000.0f};
			t3DVector trg = {0,0,0};
			gluLookAt(eye[0],eye[1],eye[2],trg[0],trg[1],trg[2],0,1,0);
		}

		glBindTexture(GL_TEXTURE_2D,fa2);
		tx_BeginEnvMap();
			legycsapo.TexDraw(1,1);
		tx_EndEnvMap();

		//set2d(0,wm_height,wm_width,0);
		//WhiteFadeIn(sync%3950,3000);
	}
}

//27839
/*
76531
83451 6920
89998 (90100) 13569
97382 20851
*/
void konyha_maszkal(int sync)
{
  /*if (sync<27839)
  {
	  set3d(wm_fov,wm_width/(float)wm_height,wm_zNear,wm_zFar);

	  glEnable(GL_TEXTURE_2D);

      if (sync<=
		  t3DVector eye = {	-30+(-35+30)*(sync,
							          ,
							          };
      t3DVector trg = { ,
                        ,
                        };
		  gluLookAt(eye[0],eye[1],eye[2],trg[0],trg[1],trg[2],0,1,0);

		  //glRotatef(7*my_sin(my_pi*2*(sync%6966)/6966.0f),0,0,1);


		  glEnable(GL_LIGHTING); 

		  glBindTexture(GL_TEXTURE_2D,sky);	
		  skybox.TexDraw(7,7);

		  glEnable(GL_CULL_FACE);
		  glCullFace(GL_BACK);
			  draw_sparhert();
			  draw_falak();
			  draw_asztal();
			  glTranslatef(-25,0,-43);
			  draw_mosogato();
			  glTranslatef(25,0,43);
			  draw_kisasztal();
		  glDisable(GL_CULL_FACE);
		  glDisable(GL_LIGHTING);
    if (sync>=12432)
    {
      FadeOut(sync-12432,1500,1,1,1);
    }
  }*/
}

void konyha_celkereszt(int sync)
{

}

/*
20945
21200
24405
24683
27841
28143
31348
31626
*/

void FadeOut(int sync, int length, float dr, float dg, float db)
{
  set2d(0,wm_height,wm_width,0);

	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	glColor4f(dr,dg,db,(sync/(float)length));
	glBegin(GL_QUADS);
		glVertex2f(0,0);
		glVertex2f(0,wm_height);
		glVertex2f(wm_width,wm_height);
		glVertex2f(wm_width,0);
	glEnd();
	glColor4f(1,1,1,1);

	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
	
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_LIGHTING);
}

void FadeIn(int sync, int length, float dr, float dg, float db)
{
  set2d(0,wm_height,wm_width,0);

	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	//glBlendFunc(GL_SRC_ALPHA,GL_ONE);
  glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

	glColor4f(dr,dg,db,1-(sync/(float)length));
	glBegin(GL_QUADS);
		glVertex2f(0,0);
		glVertex2f(0,wm_height);
		glVertex2f(wm_width,wm_height);
		glVertex2f(wm_width,0);
	glEnd();
	glColor4f(1,1,1,1);

	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
	
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_LIGHTING);
}