#include "lib/shared.fx"
#include "lib/structs.fx"

float4x4	mWorld;
float4x4	mWorldView;
float4x4	mWVP;

texture		tBase;
sampler2D	smpBase = sampler_state {
	Texture = <tBase>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};
texture		tOcc;
sampler2D	smpOcc = sampler_state {
	Texture = <tOcc>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};
texture		tEnv;
sampler2D	smpEnv = sampler_state {
	Texture = <tEnv>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

SPosTex3 vsMain11( SPosNTex2 i ) {
	SPosTex3 o;
	o.pos = mul( i.pos, mWVP );
	o.uv[0] = i.uv[0];
	o.uv[1] = i.uv[1];

	float3 vn = mul( i.normal, mWorldView );
	o.uv[2] = vn.xy * 0.5 + 0.5;
	return o;
}

half4 psMain( SPosColTex3 i ) : COLOR {
	half4 cbase = tex2D( smpBase, i.uv[0] );
	half4 cocc = tex2D( smpOcc, i.uv[1] );
	half4 cenv = tex2D( smpEnv, i.uv[2] );
	return (cocc + cenv*0.15) * cbase;
}

SPosTex2 vsMainFFa( SPosNTex2 i ) {
	SPosTex2 o;
	o.pos = mul( i.pos, mWVP );

	float3 vn = mul( i.normal, mWorldView );
	o.uv[0] = vn.xy * 0.5 + 0.5;
	o.uv[1] = i.uv[1];
	return o;
}

SPosTex vsMainFFb( SPosTex i ) {
	SPosTex o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv;
	return o;
}


technique tec11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain();
	}
	pass PLast {
	}
}

technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMainFFa();
		PixelShader = NULL;

		Sampler[0] = (smpEnv);
		Sampler[1] = (smpOcc);

		TextureFactor = (float4(0.15,0.15,0.15,0.15));

		ColorOp[0]	 = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = TFactor;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;

		ColorOp[1]	 = Add;
		ColorArg1[1] = Texture;
		ColorArg2[1] = Current;
		AlphaOp[1]	 = SelectArg1;
		AlphaArg1[1] = Texture;

		ColorOp[2]	 = Disable;
		AlphaOp[2]	 = Disable;
	}
	pass P1 {
		VertexShader = compile vs_1_1 vsMainFFb();
		PixelShader = NULL;

		AlphaBlendEnable = True;
		SrcBlend = Zero;
		DestBlend = SrcColor;
		ZWriteEnable = False;

		Sampler[0] = (smpBase);

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;

		ColorOp[1]	 = Disable;
		AlphaOp[1]	 = Disable;
	}

	pass PLast {
		AlphaBlendEnable = False;
		ZWriteEnable = True;
	}
}
