#include "lib/shared.fx"
#include "lib/structs.fx"

float4x4	mWVP;
float4 		vColor;

texture		tBase;
sampler2D	smpBase = sampler_state {
	Texture = <tBase>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

SPosTex vsMain( SPosTex i ) {
	SPosTex o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv;
	return o;
}

half4 psMain( SPosTex i ) : COLOR {
	return tex2D( smpBase, i.uv ) * vColor;
}

technique tec11
< bool backToFront = true; >
{
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = compile ps_1_1 psMain();
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
		ZEnable = False;
		ZWriteEnable = False;
		
		CullMode = None;
	}
	pass PLast {
		AlphaBlendEnable = False;
		ZWriteEnable = True;
		ZEnable = True;
		CullMode = <iCull>;
		FillMode = Solid;
	}
}


technique tecFFP
< bool backToFront = true; >
{
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = NULL;
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
		ZEnable = False;
		ZWriteEnable = False;
		
		CullMode = None;

		Sampler[0] = (smpBase);
		TextureFactor = (vColor);

		ColorOp[0]	 = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = TFactor;
		AlphaOp[0]	 = Modulate;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = TFactor;
		ColorOp[1]	 = Disable;
		AlphaOp[1]	 = Disable;
	}
	pass PLast {
		AlphaBlendEnable = False;
		ZWriteEnable = True;
		ZEnable = True;
		CullMode = <iCull>;
		FillMode = Solid;
	}
}
