#include "lib/shared.fx"
#include "lib/structs.fx"

float4x4	mWVP;
float4 		vColor;

SPos vsMain( SPos i ) {
	SPos o;
	o.pos = mul( i.pos, mWVP );
	return o;
}

half4 psMain() : COLOR {
	return vColor;
}

technique tec11
< bool backToFront = true; >
{
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = compile ps_1_1 psMain();
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
		ZEnable = False;
		ZWriteEnable = False;
		
		CullMode = None;
	}
	pass PLast {
		AlphaBlendEnable = False;
		ZWriteEnable = True;
		ZEnable = True;
		CullMode = <iCull>;
	}
}

technique tecFFP
< bool backToFront = true; >
{
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = NULL;
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
		ZEnable = False;
		ZWriteEnable = False;
		
		CullMode = None;

		TextureFactor = (vColor);

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = TFactor;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = TFactor;
		ColorOp[1]	 = Disable;
		AlphaOp[1]	 = Disable;
	}
	pass PLast {
		AlphaBlendEnable = False;
		ZWriteEnable = True;
		ZEnable = True;
		CullMode = <iCull>;
	}
}
