#include "lib/shared.fx"
#include "lib/structs.fx"

float4x4	mWorld;
float4x4	mWVP;
float4		vColor;
float4		vTexture;

texture		tBase;
sampler2D	smpBase = sampler_state {
	Texture = <tBase>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

SPosTex vsMain( SPosTex i ) {
	SPosTex o;
	o.pos = mul( i.pos, mWVP );
	o.uv.x = i.uv.x * vTexture.x + vTexture.z;
	o.uv.y = i.uv.y * vTexture.y + vTexture.w;
	return o;
}

technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = NULL;

		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		ZWriteEnable = False;
		ZEnable = False;

		TextureFactor = <vColor>;
		Sampler[0] = <smpBase>;
		ColorOp[0]	 = Modulate;
		ColorArg1[0] = TFactor;
		ColorArg2[0] = Texture;
		AlphaOp[0]	 = Modulate;
		AlphaArg1[0] = TFactor;
		AlphaArg2[0] = Texture;
		ColorOp[1]	 = Disable;
		AlphaOp[1]	 = Disable;
	}
	pass PLast {
		AlphaBlendEnable = False;
		ZEnable = True;
		ZWriteEnable = True;
	}
}
