/* twirlripple.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include <math.h>
#include "effect.h"
#include "twirlripple.h"
#ifdef WINDOWS
#define M_PI 3.14159265358979323846
#endif

extern int sinus[1024];

void twirlripple_run(void *d, long time) {
  twirlripple_data *data=(twirlripple_data *)d;
  int x, y, angle=0, dist=0;
  unsigned long *source=data->source->data, *dest=data->dest->data;

  for(y=0; y<data->dest->height; y++) {
    for(x=0; x<data->dest->width; x++) {
      dist=abs(data->rectpolar[2*(y*data->dest->width+x)]+(int)(data->distamplitude*sin(dist/data->distfrequency+data->distphase)))%data->source->width;
      angle=abs(data->rectpolar[2*(y*data->dest->width+x)+1]+(int)(data->angleamplitude*sin(angle/data->anglefrequency+data->anglephase))+data->angleadd)%data->source->height;
      *dest++=source[data->polarrect[dist*data->source->width+angle]];
    }
  }
}

void twirlripple_free(effect *effect) {
  twirlripple_data *data=(twirlripple_data *)effect->data;

  if(data->polarrect)
    free(data->polarrect);
  if(data->rectpolar)
    free(data->rectpolar);
  free(effect->data);
}

void twirlripple_new(effect *effect) {
  effect->run=twirlripple_run;
  effect->new=twirlripple_new;
  effect->freee=twirlripple_free;
  effect->data=(twirlripple_data *)calloc(sizeof(twirlripple_data), 1);
}

void twirlripple_new_tables(twirlripple_data *data) {
  double x, y, angle, dist, tempx, tempy;
  int srcwidth=data->source->width, srcheight=data->source->height;
  int destwidth=data->dest->width, destheight=data->dest->height;
  double maxdist=sqrt((destwidth/2)*(destwidth/2)+(destheight/2)*(destheight/2));
  int *i;

  data->rectpolar=malloc(2*destwidth*destheight*sizeof(int));
  data->polarrect=malloc(srcwidth*srcheight*sizeof(int));
  i=data->rectpolar;

  for(y=0; y<destheight; y++) {
    for(x=0; x<destwidth; x++) {
      tempx=(x-1)-destwidth/2;
      tempy=y-destheight/2;
      dist=sqrt(tempx*tempx+tempy*tempy);
      angle=acos(tempx/dist);
      if(tempy>0)
	angle=2*M_PI-angle;
      *i++=(int)floor(dist*srcheight/maxdist);
      *i++=(int)floor(angle*srcwidth/M_PI/2);
    }
  }

  i=data->polarrect;
  maxdist=sqrt((srcwidth/2)*(srcwidth/2)+(srcheight/2)*(srcheight/2));
  dist=0;
  for(x=0; x<srcwidth; x++) {
    angle=0;
    for(y=0; y<srcheight; y++) {
      tempy=-sin(angle)*dist+srcheight/2;
      tempx=cos(angle)*dist+srcwidth/2;
      if(tempx<0)
	tempx=0;
      else if(tempx>=srcwidth)
	tempx=srcwidth-1;
      if(tempy<0)
	tempy=0;
      else if(tempy>=srcheight)
	tempy=srcheight-1;
      *i++=(int)floor(tempy)*srcwidth+(int)floor(tempx);
      angle+=2*M_PI/srcheight;
    }
    dist=x*maxdist/srcwidth;
  }
}
