/* tg03demo05.c */

#include "tg03demo.h"

extern int sinus[1024];

#define POS SONGPOSTOTIME
#define ANIM_NUM_FRAMES(firstframe, lastframe)  (1+(lastframe)-(firstframe))

// Anim stuff
static const long animspeed      = POS(0,4)-POS(0,0);   /* Anim speed relative to track positions */
static const long animframesnum  = ANIM_NUM_FRAMES(TMFD1, TMFD4);

static void params_05_copy_title(void *d, long time) {
  copy_data *data=(copy_data *)d;
  if(time<0)
    time=0;

  if(animspeed > 0)
      data->source = pictures[TMFD1 + ((time / animspeed) % animframesnum)];
   data->alpha = 0xa0;
}

static void params_05_horizontalblur(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;
  if(time<0)
    time=0;
   data->amount = 1;
}

static void params_05_zoom(void *d, long time)
{
   zoomrotate_data *zrdata;
   if(time < PART_05_START)
      time += PART_05_START;
   zrdata = (zoomrotate_data *)d;
   zrdata->zoom = 50000+50*sinus[(time/4)%1023];
   zrdata->angle += 10000;
   zrdata->dx = time / 64;
   zrdata->dy = time / 64;

}

void part_05() {
   copy_data *copydata;
   horizontalblur_data *hbdata;
   zoomrotate_data *zrdata;
   int i;

   if(effectlist)
      effectlist_free(effectlist);
   effectlist=NULL;

   // Animate title and put to screenbuffer
   effectlist=effectlistentry_new(effect_new(copy_new, params_05_copy_title),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[TMFD1];
   copydata->dest=&screenbuffer;
   copydata->sourcex=0;
   copydata->sourcey=0;
   copydata->destx=20;
   copydata->desty=30;
   copydata->sourcewidth=pictures[TMFD1]->width;
   copydata->sourceheight=pictures[TMFD1]->height;
   copydata->destwidth=pictures[TMFD1]->width;
   copydata->destheight=pictures[TMFD1]->height;
   copydata->alpha=0x7f;
   copydata->mode=COPY_MODE_NORMAL;
   copydata->interpolate=0;

   // Blur and put to screenbuffer
   effectlist=effectlistentry_new(effect_new(horizontalblur_new, params_05_horizontalblur),
             effectlist);
   hbdata=(horizontalblur_data *)effectlist->effect->data;
   hbdata->source=pictures[TEMP];
   hbdata->dest=&screenbuffer;
   hbdata->amount=0;

   // Rotzoom
   effectlist = effectlistentry_new(effect_new(zoomrotate_new, params_05_zoom), effectlist);
   zrdata         = (zoomrotate_data *)effectlist->effect->data;
   zrdata->source = pictures[F_DPIC];
   zrdata->dest   = pictures[TEMP];
   zrdata->angle  = 0;
   zrdata->dx     = 1;
   zrdata->dy     = 1;
   zrdata->px     = 0;
   zrdata->py     = 0;
   zrdata->zoom   = 1;
}
