/* tg03demo04.c */

#include "tg03demo.h"

extern int sinus[1024];

#define POS SONGPOSTOTIME
#define ANIM_NUM_FRAMES(firstframe, lastframe)  (1+(lastframe)-(firstframe))

// Anim stuff
static const long animspeed      = POS(0,2)-POS(0,0);   /* Anim speed relative to track positions */
static const long animframesnum  = ANIM_NUM_FRAMES(T1, T16);

static void params_04_horizontalblur(void *d, long time) {
   verticalblur_data *data=(verticalblur_data *)d;
   time-=PART_04_START;
   if(time<0)
      time=0;
   data->amount = 3;
}

static void params_03_copy_iyf1(void *d, long time) {
   copy_data *data = (copy_data *)d;
   if(animspeed > 0)
      data->alpha = (0xff/4)*((time/animspeed) % animframesnum);
}

static void params_04_copy_lakris(void *d, long time) {
   copy_data *data=(copy_data *)d;
   static short f = T1;
   if(time<0)
      time=0;

   data->source = pictures[f];

   if(animspeed > 0)
      data->source = pictures[T1 + ((time / animspeed) % animframesnum)];

   data->alpha = 255;
}

static void params_03_zoom(void *d, long time)
{
   zoomrotate_data *zrdata;
   zrdata = (zoomrotate_data *)d;
   zrdata->zoom = 6000+125*sinus[(time/8)%1023];
}

void part_04() {
   copy_data *copydata;
   horizontalblur_data *hbdata;
   zoomrotate_data *zrdata;
   int i;

   if(effectlist)
      effectlist_free(effectlist);
   effectlist=NULL;

   // blur and put to screenbuffer
   effectlist=effectlistentry_new(effect_new(horizontalblur_new, params_04_horizontalblur), effectlist);
   hbdata=(horizontalblur_data *)effectlist->effect->data;
   hbdata->source=pictures[TEMP];
   hbdata->dest=&screenbuffer;
   hbdata->amount=1;

   // lakris
   effectlist=effectlistentry_new(effect_new(copy_new, params_03_copy_iyf1),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[IYF4];
   copydata->dest=pictures[TEMP];
   copydata->sourcex=0;
   copydata->sourcey=0;
   copydata->destx=220;
   copydata->desty=20;
   copydata->sourcewidth=pictures[IYF4]->width;
   copydata->sourceheight=pictures[IYF4]->height;
   copydata->destwidth=pictures[IYF4]->width;
   copydata->destheight=pictures[IYF4]->height;
   copydata->alpha=0x7f;
   copydata->mode=COPY_MODE_NORMAL;
   copydata->interpolate=0;

   // in
   effectlist=effectlistentry_new(effect_new(copy_new, params_03_copy_iyf1),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[IYF1];
   copydata->dest=pictures[TEMP];
   copydata->sourcex=0;
   copydata->sourcey=0;
   copydata->destx=250;
   copydata->desty=70;
   copydata->sourcewidth=pictures[IYF1]->width;
   copydata->sourceheight=pictures[IYF1]->height;
   copydata->destwidth=pictures[IYF1]->width;
   copydata->destheight=pictures[IYF1]->height;
   copydata->alpha=0x7f;
   copydata->mode=COPY_MODE_NORMAL;
   copydata->interpolate=0;

   // your
   effectlist=effectlistentry_new(effect_new(copy_new, params_03_copy_iyf1),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[IYF2];
   copydata->dest=pictures[TEMP];
   copydata->sourcex=0;
   copydata->sourcey=0;
   copydata->destx=250;
   copydata->desty=110;
   copydata->sourcewidth=pictures[IYF2]->width;
   copydata->sourceheight=pictures[IYF2]->height;
   copydata->destwidth=pictures[IYF2]->width;
   copydata->destheight=pictures[IYF2]->height;
   copydata->alpha=0x7f;
   copydata->mode=COPY_MODE_NORMAL;
   copydata->interpolate=0;

   // face
   effectlist=effectlistentry_new(effect_new(copy_new, params_03_copy_iyf1),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[IYF3];
   copydata->dest=pictures[TEMP];
   copydata->sourcex=0;
   copydata->sourcey=0;
   copydata->destx=200;
   copydata->desty=130;
   copydata->sourcewidth=pictures[IYF3]->width;
   copydata->sourceheight=pictures[IYF3]->height;
   copydata->destwidth=pictures[IYF3]->width;
   copydata->destheight=pictures[IYF3]->height;
   copydata->alpha=0x7f;
   copydata->mode=COPY_MODE_NORMAL;
   copydata->interpolate=0;

   // Lakris anim
   effectlist=effectlistentry_new(effect_new(copy_new, params_04_copy_lakris),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[T1];
   copydata->dest=pictures[TEMP];
   copydata->sourcex=0;
   copydata->sourcey=0;
   copydata->destx=20;
   copydata->desty=0;
   copydata->sourcewidth=pictures[T1]->width;
   copydata->sourceheight=pictures[T1]->height;
   copydata->destwidth=pictures[T1]->width;
   copydata->destheight=pictures[T1]->height;
   copydata->alpha=0xff;
   copydata->mode=COPY_MODE_ADD;
   copydata->interpolate=0;

   // Rotzoom
   effectlist = effectlistentry_new(effect_new(zoomrotate_new, params_03_zoom), effectlist);
   zrdata         = (zoomrotate_data *)effectlist->effect->data;
   zrdata->source = pictures[TEXTURE];
   zrdata->dest   = pictures[TEMP];
   zrdata->angle  = 0;
   zrdata->dx     = 2;
   zrdata->dy     = 20;
   zrdata->px     = 0;
   zrdata->py     = 0;
   zrdata->zoom   = 1;
}
