/* tg03.c */

#include "tg03demo.h"

buffer **pictures;
int renderwidth=400, renderheight=300, screenwidth=400, screenheight=300;
int npictures;
char *production_window_title="The making of fuzzy dice";

#ifdef MP3_MUSIC
   char *production_mp3_filename="data/fuzzy128kbit.mp3";
#elif MOD_MUSIC
   char *production_mod_filename="data/tuneforit.mod";
#endif

char *picture_filenames[]={
   "data/gathering.png",
   "data/colon.png",
   "data/2003.png",
   "data/hamar.png",
   "data/fuzzyfull.jpg",
   "data/da.png",
   "data/androids.png",
   "data/symbol.png",
   "data/present.png",
   "data/endscreen.png",
   "data/endscreen.png",
   "data/wabbit.png",
   "data/title2.png",
   "data/f001.png",
   "data/f002.png",
   "data/f003.png",
   "data/f004.png",
   "data/bubble.png",
   "data/texture.png",
   "data/texture2.png",
   "data/f_dpic.png",
   "data/androids2.png",
   "data/a1.png",
   "data/a2.png",
   "data/a3.png",
   "data/lakris/twirl01.png",
   "data/lakris/twirl02.png",
   "data/lakris/twirl03.png",
   "data/lakris/twirl04.png",
   "data/lakris/twirl05.png",
   "data/lakris/twirl06.png",
   "data/lakris/twirl07.png",
   "data/lakris/twirl08.png",
   "data/lakris/twirl09.png",
   "data/lakris/twirl10.png",
   "data/lakris/twirl11.png",
   "data/lakris/twirl12.png",
   "data/lakris/twirl13.png",
   "data/lakris/twirl14.png",
   "data/lakris/twirl15.png",
   "data/lakris/twirl16.png",
   "data/tmfd1.png",
   "data/tmfd2.png",
   "data/tmfd3.png",
   "data/tmfd4.png",
   "data/iyf1.png",
   "data/iyf2.png",
   "data/iyf3.png",
   "data/iyf4.png",
   "data/tmofd.png",
   "data/wdw.png",
   "data/gtz.png",
   "data/endlame.png",
   NULL
};

/* Allocate a temporary buffer and load pictures */
void production_startup()
{
  int i=0;

  while(picture_filenames[i]!=NULL)
    i++;

  npictures=i+1;
  pictures=(struct buffer **)calloc(npictures, sizeof(struct buffer *));

  i=0;
  while(picture_filenames[i]!=NULL)
  {
    if(!(pictures[i]=buffer_load(picture_filenames[i])))
    {
      fprintf(stderr, "Couldn't load %s\n", picture_filenames[i]);
      exit(1);
    }
    i++;
  }
  pictures[i]=buffer_new(renderwidth, renderheight);
}

void production_shutdown() {
  int i;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  for(i=0; i<npictures; i++)
    buffer_free(pictures[i]);
  free(pictures);
}

/**
   jrn comment:
   A timeline consists of a millisecond counter of when to *start* a part, and
   a pointer to a function to run when that counter is exceeded. The function
   called (the current part running) may then use additional timers to sync to
   the track.

   PART_01_START is a macro defined as SONGPOSTOTIME(0,1) which means pattern
   0, position 1.
**/
timelineentry timeline[] = {
   { PART_01_START, part_01 },
   { PART_02_START, part_02 },
   { PART_03_START, part_05 },
   { PART_04_START, part_04 },
   { PART_05_START, part_03 },
   { PART_06_START, part_06 },
   { PART_END, production_quit },
   { (int)NULL, (int)NULL }
};

