// fineffekt.c
/*
 * Copyright 2003 J-run/Androids
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "effect.h"
#include "fineffekt.h"

#define addpass1(data1, data2) (((data2)&0xfefefe)+((data1)&0xfefefe))

extern int sinus[1024];

static long col[256];

static long buf1[120000];
static long buf2[120000];

static unsigned char plasma(long i, long j)
{
   unsigned char tmp;
   tmp = sinus[(i*j)%1024];
   return(tmp);
}

void fineffekt_run(void *d, long time) {
   fineffekt_data *data=(fineffekt_data *)d;

   unsigned long *source = data->dest->data;
   unsigned long *dest   = data->dest->data;
   int width = data->dest->width, height = data->dest->height;
   int position = data->position;
   int start, end, x, y, l, i, j;

   int line=0;

   // palette
   for(i=0;i<256;i++)
      col[i] = 0xff000000 |(0x00ff0000&(i+position<<16)) | (0x0000ff00&(i+position<<8)) | (0x000000ff&i+position);

   // select palette color for pixel
   for(x=0;x<300;x++)
   {
      for(y=0;y<400;y++)
      {
         *dest++ = col[plasma(x+position,y+position)];
      }
   }
}

void fineffekt_free(effect *effect) {
   free(effect->data);
}

void fineffekt_new(effect *effect) {
   effect->run=fineffekt_run;
   effect->new=fineffekt_new;
   effect->parameters=NULL;
   effect->freee=fineffekt_free;
   effect->data=(fineffekt_data *)calloc(sizeof(fineffekt_data), 1);
}
