/* production.h
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _PRODUCTION_H
#define _PRODUCTION_H

/* A macro for calculating time in milliseconds from song position */
/* Each production must define PATTERNLENGTH and BPM separately */
#define SONGPOSTOTIME(pattern, position) ((((pattern)-1)*PATTERNLENGTH+(position))*7500/BPM)

/* A time line entry */
struct timelineentry {
  /* When this job should be run */
  long time;
  /* The job to run */
  void (*job)();
};
typedef struct timelineentry timelineentry;

extern int renderwidth, renderheight, screenwidth, screenheight;
extern char *production_window_title, *production_mp3_filename, *production_mod_filename;
extern timelineentry timeline[];

/*
   Use module or mp3
*/
//#define MOD_MUSIC 1
#ifndef MOD_MUSIC
   #define MP3_MUSIC
#endif


/* timeline.c functions */
extern void production_startup();
extern void production_shutdown();
extern void production_quit();

#endif
