#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "glWindow.h"
#include "algebra.h"
#include "glJPEG.h"
#include <list>
#include  <bassmod.h>
#include "setup.h"
#include "spring.h"

gl_window win;
bool running=true;

bool fade = false;
float fade_start;
bool credit = false;
float credit_start;

float fx0_timeS;
float fx0_timeE = 0.0;
float fx0_alpha;

char musicName[] = "Ylkyl_1.it";

inline float time () { return GetTickCount(); }

class fxFragment {
    public:
        fxFragment () { endTime=0.0; };
        virtual void draw (void) {};
        virtual void init (void) {};
        
        float startTime, endTime;
};

#define NUM_TRI 16

class fxTriangles : public fxFragment {
    private:
        vec3 center[NUM_TRI];
        vec3 rotate[NUM_TRI];
        vec3 color[NUM_TRI];
        float timeS[NUM_TRI];
        float timeE[NUM_TRI];
        float modeS, modeE;
    
        void draw_triangle (int i);
    public:
        void init ();
        void draw ();
};

#define NUM_VLIN 7

class fxVlines : public fxFragment {
    private:
        float xx[NUM_VLIN];
        float add_xx[NUM_VLIN];
        float timeS[NUM_VLIN];
        float timeE[NUM_VLIN];
        float width[NUM_VLIN];
    public:
        void init () { for (int i=0; i<NUM_VLIN; i++) timeE[i]=0; }
        void draw ();
};

#define NUM_CIRCLE 5

class fxCircles : public fxFragment {
    private:
        vec3 center[NUM_CIRCLE];
        vec3 col[NUM_CIRCLE];
        float r0[NUM_CIRCLE];
        float r1[NUM_CIRCLE];
        float add0[NUM_CIRCLE];
        float add1[NUM_CIRCLE];
        float timeS[NUM_CIRCLE];
        float timeE[NUM_CIRCLE];
        
        void draw_circle (float r1, float r2);
    public:
        void init() { for (int i=0; i<NUM_CIRCLE; i++) timeE[i]=0; }
        void draw ();
};

#define NUM_HALFS 14

class fxHalfCircles : public fxFragment {
    private:
        vec3 center[NUM_HALFS];
        vec3 col[NUM_HALFS];
        float r0[NUM_HALFS];
        float r1[NUM_HALFS];
        float timeS[NUM_HALFS];
        float timeE[NUM_HALFS];
        float angle[NUM_HALFS];
        float speed[NUM_HALFS];
        
        void draw_half_circle (float r1,float r2, float angle);
    public:
        void init () { for (int i=0; i<NUM_HALFS; i++) timeE[i]=0; }
        void draw();
        
};

#define NUM_TEX 4

class fxTextures : public fxFragment {
    private:
        int tex[NUM_TEX];
        vec3 center[NUM_TEX];
        vec3 col[NUM_TEX];
        float sc[NUM_TEX];
        float r0[NUM_TEX];
        float r1[NUM_TEX];
        float timeS[NUM_TEX];
        float timeE[NUM_TEX];
        
        void draw_tex (int i);
    public:
        void init () { for (int i=0; i<NUM_TEX; i++) timeE[i]=0; }
        void draw ();
};

#define NUM_CURVES 10

class fxCurves : public fxFragment {
    private:
        vec3 p[NUM_CURVES][4];
        vec3 add[NUM_CURVES][4];
        vec3 col[NUM_CURVES];
        float timeS[NUM_CURVES];
        float timeE[NUM_CURVES];
        
        vec3 eval (vec3* p, float t);
    public:
        void init () { for (int i=0; i<NUM_CURVES; i++) timeE[i]=0; }
        void draw ();        
};

#define NUM_LINES 30

class fxLines : public fxFragment {
    private:
        vec3 col[NUM_LINES];
        vec3 p0[NUM_LINES];
        vec3 p1[NUM_LINES];
        vec3 a0[NUM_LINES];
        vec3 a1[NUM_LINES];
        float timeS[NUM_LINES];
        float timeE[NUM_LINES];
        
        void draw_line3d(vec3& p0, vec3& p1);
    public:
        void init () { for (int i=0; i<NUM_LINES; i++) timeE[i]=0; }
        void draw ();
};

#define NUM_SPRING  14

class springs {
    private:
        vec3 pts[512];
        vec3 center[NUM_SPRING];
        vec3 rotate[NUM_SPRING];
        vec3 r1[NUM_SPRING];
        float timeS[NUM_SPRING];
        float timeE[NUM_SPRING];
        
        void draw_spiral (float q);
    public:
        springs ();
        void draw ();            
};

springs :: springs ()
{
    int q=0;
    for (int i=0; i<512; i++,q+=3)
        pts[i]=vec3(spring_data[q],spring_data[q+1],spring_data[q+2]);
    for (int i=0; i<NUM_SPRING; i++) timeE[i]=0.0;
}

void springs :: draw_spiral (float q)
{
    glColor4f(1,1,1,q);
    glBegin(GL_POINTS);
    for (int i=0; i<512; i++) {
        glVertex3fv(pts[i].n);
    }
    glEnd();
    glColor4f(1,1,1,q*0.6);
    for (int j=0; j<16; j++) {
        glBegin(GL_LINE_STRIP);
        for (int i=j*32; i<j*32+32; i++) glVertex3fv(pts[i].n);
        glEnd();
    }
    for (int j=0; j<32; j++) {
        glBegin(GL_LINE_LOOP);
        for (int i=0; i<16; i++) glVertex3fv(pts[(i<<5)+j].n);
        glEnd();
    }
}

void springs :: draw ()
{
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(45.0, 4.0/3.0, 0.1, 500.0);
    glMatrixMode(GL_MODELVIEW);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    gluLookAt(0,0,5, 0,0,0, 0,1,0);
    
    float t = time();
    float a;
    for (int i=0; i<NUM_SPRING; i++) {
        if (timeE[i]<t) {
            center[i]=vec3((frnd()*2-1)*3,(frnd()*2-1)*3,(frnd()*2-1)*3);
            rotate[i]=vec3(frnd()*2-1,frnd()*2-1,frnd()*2-1);
            r1[i]=vec3(frnd()*2-1,frnd()*2-1,frnd()*2-1);
            timeS[i]=t;
            timeE[i]=irnd(500)+600+timeS[i];
        }
        if ((t>timeS[i])&&(t<timeE[i])) {
            a=0.4;
            if (t<timeS[i]+300) a=(1.0-(timeS[i]+300-t)/300.0)*0.3;
            if (t>timeE[i]-300) a=((timeE[i]-t)/300.0)*0.3;
            glPushMatrix();
            glRotatef(t*0.05,r1[i][0],r1[i][1],r1[i][2]);
            glTranslatef(center[i][0],center[i][1],center[i][2]);
            glRotatef(t*0.1,rotate[i][0],rotate[i][1],rotate[i][2]);
            draw_spiral(a);
            glPopMatrix();
        }
    }
}

springs spring;


class fxEngine {
    private:
        list<fxFragment*> fx;
        float lastAdded;
    public:
        fxEngine () { fx.clear(); lastAdded=0; }
        ~fxEngine () { fx.clear(); }
        void update ();
};

void fxEngine :: update ()
{
    float t = time();

    if (t>lastAdded+150) {  //add new fx
        fxFragment* n = NULL;
        DWORD pos=BASSMOD_MusicGetPosition();
        if (LOWORD(pos)>=1) {
        int q=irnd(4);
        switch (q) {
            case 0:
                if (LOWORD(pos)>=14) {
                    if (irnd(2))
                        n = new fxLines;
                    else n=new fxTriangles;
                }
                else n= new fxCurves;
                break;
            case 1:
                if ((LOWORD(pos)>=8)) {
                    int blabla=irnd(4);
                    switch (blabla) {
                        case 0: n=new fxLines; break;
                        case 1: n=new fxTriangles; break;
                        case 2: n=new fxHalfCircles; break;
                        case 3: n=new fxTextures; break;
                    }
                } else n = new fxVlines;
                break;
            case 2:
                if (LOWORD(pos)>=9) n = new fxCircles;
                else n= new fxHalfCircles;
                break;
            case 3:
                n = new fxTextures;
                break;
        }
        if (n) {
            n->startTime=t+irnd(250);
            n->endTime=300+irnd(500)+t;
            n->init();
            fx.push_back(n);
            lastAdded=t;
        }
        }
    }
    for (list<fxFragment*>::iterator F=fx.begin(); F != fx.end(); F++) {
        if ((t>=(*F)->startTime)&&(t<=(*F)->endTime)) {
            (*F)->draw();
        } else {
            if (t>(*F)->endTime) {
                delete *F;
                F=fx.erase(F);
            }
        }
    }
}

void fxTriangles :: draw_triangle (int i)
{
        glPushMatrix();
        glTranslatef(center[i][0]+(frnd()*2-1)*0.15,center[i][1]+(frnd()*2-1)*0.15,center[i][2]+(frnd()*2-1)*0.15);
        glRotatef(time()*0.6, rotate[i][0],rotate[i][1],rotate[i][2]);
        glBegin(GL_TRIANGLES);
        glVertex3f(-1,-1,0);
        glVertex3f(0,1,0);
        glVertex3f(1,-1,0);
        glEnd();
        glPopMatrix();
}

void fxTriangles :: init ()
{
    for (int i=0; i<NUM_TRI; i++) timeE[i]=0;
    modeE=0;
}

void fxTriangles :: draw ()
{
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(45.0, 4.0/3.0, 0.1, 500.0);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    gluLookAt (0,0, 2.0, 0,0,0, 0,1,0);
    
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glLineWidth(2.0);
    
    float t = time();
    
    if (modeE<t) {
        modeS=time()+irnd(400);
        modeE=irnd(300)+100+modeS;
    }
    
    for (int i=0; i<NUM_TRI; i++) {
        if (timeE[i] < t) {
            center[i]=vec3(frnd()*3-1.5,frnd()*3-1.5,frnd()*3-1.5);
            rotate[i]=vec3(frnd()*2-1,frnd()*2-1,frnd()*2-1);
            color[i]=vec3(frnd(),frnd(),frnd());
            timeS[i]=time()+irnd(100);
            timeE[i]=irnd(500)+140 + timeS[i];
        }
        if ((t>timeS[i])&&(t<timeE[i])) {
            /*if ((t>modeS)&&(t<modeE)) {
                glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                glColor4f(1,1,1,0.4);
            } else*/ {
                glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                glColor4f(color[i][0],color[i][1],color[i][2],0.3);
            }
            draw_triangle(i);
        }
    }
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    glLineWidth(1.0);
}

void fxVlines :: draw ()
{
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(-4,4,-3,3,-1,1);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    float t = time();
    float x;
    for (int i=0; i<NUM_VLIN; i++) {
        if (timeE[i] < t) {
            xx[i]=frnd()*6-3;
            add_xx[i]=(frnd()*2-1)*0.009;
            timeS[i]=time()+irnd(100);
            timeE[i]=irnd(400)+100+timeS[i];
            width[i]=frnd()*0.25+0.02;
        }
        if ((t>timeS[i])&&(t<timeE[i])) {
            x=xx[i]+add_xx[i]*(t-timeS[i]);
            glColor4f(1,1,1, 0.3);
            glRectf(x-width[i],-3,x+width[i],3);
        }        
    }
}

void fxCircles :: draw_circle (float r1, float r2)
{
    #define DIVISION 30
    r1=fabs(r1);
    r2=fabs(r2);
    
    float c,s,oldc,olds;
    oldc=1.0;
    olds=0.0;
    
    glBegin(GL_QUADS);
    for (int i=1; i<=DIVISION; i++) {
        c=cos((2.0*M_PI)/DIVISION*i);
        s=sin((2.0*M_PI)/DIVISION*i);
        
        glVertex2f(oldc*r2,olds*r2);
        glVertex2f(c*r2,s*r2);
        glVertex2f(c*r1,s*r1);
        glVertex2f(oldc*r1,olds*r1);
        
        oldc=c;
        olds=s;
    }
    glEnd();
}

void fxCircles :: draw ()
{
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(-4,4,-3,3,-1,1);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    float t = time();
    float rr0,rr1;
    
    for (int i=0; i<NUM_CIRCLE; i++) {
        if (timeE[i] < t) {
            r0[i]=frnd()+0.7;
            r1[i]=frnd()+0.4;
            add0[i]=(frnd()*2-1)*0.01;
            add1[i]=(frnd()*2-1)*0.01;
            timeS[i]=time()+irnd(100);
            timeE[i]=irnd(300)+100+timeS[i];
            col[i]=vec3(frnd(),frnd(),frnd());
            if (i&1) {
                center[i]=center[i-1];
            } else
                center[i]=vec3(frnd()*8-4,frnd()*6-3,0);
        }
        if ((t>timeS[i])&&(t<timeE[i])) {
            rr0=r0[i]+add0[i]*(t-timeS[i]);
            rr1=r1[i]+add1[i]*(t-timeS[i]);
            glColor4f(col[i][0],col[i][1],col[i][2],0.3);
            glPushMatrix();
            glTranslatef(center[i][0],center[i][1],center[i][2]);
            draw_circle(rr0,rr1);
            glPopMatrix();
        }
    }
}

void fxTextures :: draw_tex (int i)
{
    glBindTexture(GL_TEXTURE_2D, i);
    glBegin(GL_QUADS);
    glTexCoord2f(0,0); glVertex2f(-1,-1);
    glTexCoord2f(1,0); glVertex2f(1,-1);
    glTexCoord2f(1,1); glVertex2f(1,1);
    glTexCoord2f(0,1); glVertex2f(-1,1);
    glEnd();
}

void fxTextures :: draw ()
{
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(-4,4,-3,3,-1,1);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    
    glColor4f(1,1,1,0.3);
    glEnable(GL_TEXTURE_2D);
    
    float t = time();
    for (int i=0; i<NUM_TEX; i++) {
        if (timeE[i] < t) {
            center[i]=vec3(frnd()*8-4,frnd()*6-3,0);
            col[i]=vec3(frnd(),frnd()*0.3,frnd()*0.4);
            r0[i]=frnd()*2-1;
            r1[i]=frnd()*2-1;
            timeS[i]=time()+irnd(200);
            timeE[i]=irnd(400)+100+timeS[i];
            sc[i]=frnd()*4+2;
            tex[i]=irnd(3)+1;
        }
        if ((t>timeS[i])&&(t<timeE[i])) {
            glPushMatrix();
            glColor4f(col[i][0],col[i][1],col[i][2],0.3);
            glRotatef(time()*0.1, 0,0,r0[i]);
            glTranslatef(center[i][0]+(frnd()*2-1)*0.08,center[i][1]+(frnd()*2-1)*0.08,center[i][2]+(frnd()*2-1)*0.08);
            glRotatef(time()*0.1, 0,0,r1[i]);
            glScalef(sc[i],sc[i],1);
            draw_tex(tex[i]);
            glPopMatrix();
        }
    }
    glDisable(GL_TEXTURE_2D);
}

vec3 fxCurves :: eval (vec3* p, float t)
{
    float mum1=1.0-t;
    float mum12=mum1*mum1;
    float mum13=mum12*mum1;
    float mu3=t*t*t;
    return p[0]*mum13 + p[1]*(3.0*t*mum12) + p[2]*(3.0*t*t*mum1) + p[3]*mu3;
}

void fxCurves :: draw ()
{
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(-4,4,-3,3,-1,1);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    glLineWidth(2.0);
    glColor4f(1,1,1,0.3);
    
    float t = time();
    for (int i=0; i<NUM_CURVES; i++) {
        if (timeE[i] < t) {
            for (int j=0; j<4; j++) {
                p[i][j]=vec3(frnd()*8-4,frnd()*8-4,0);
                add[i][j]=vec3(frnd()*2-1,frnd()*2-1)*0.017;
            }
            timeS[i]=time()+irnd(100);
            timeE[i]=irnd(300)+100+timeS[i];
            col[i]=vec3(frnd()*0.9,frnd()*0.4,frnd());
        }
        if ((t>timeS[i])&&(t<timeE[i])) {
            vec3 a[4];
            vec3 r;
            for (int j=0; j<4; j++) {
                a[j]=p[i][j]+add[i][j]*(t-timeS[i]);
            }
            //glBegin(GL_LINE_STRIP);
            for (float x=0.0; x<=1.0; x+=1.0/8.0) {
                r=eval(a,x);
                //glVertex2f(r[0],r[1]);
                glPushMatrix();
                glColor4f(col[i][0],col[i][1],col[i][2],0.35*frnd());
                glTranslatef(r[0],r[1],0);
                glRotatef(x*360+time(),0,0,1);
                glRectf(-0.4,-0.4,0.4,0.4);
                glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                glColor4f(1,1,1,0.2);
                glRectf(-0.4,-0.4,0.4,0.4);
                glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                glPopMatrix();
            }
            //glEnd();
        }
    }
    glLineWidth(1.0);
}

void fxHalfCircles :: draw ()
{
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(-4,4,-3,3,-1,1);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    float t = time();
    float q;
    
    for (int i=0; i<NUM_HALFS; i++) {
        if (timeE[i] < t) {
            center[i]=vec3(frnd()*8-4,frnd()*6-3,0);
            r0[i]=frnd()*2+0.7*1.4;
            r1[i]=frnd()*2+0.4*1.4;
            timeS[i]=time();
            timeE[i]=irnd(300)+220 + timeS[i];
            col[i]=vec3(frnd(),frnd(),frnd());
            speed[i]=(frnd()*2-1)*0.5;
            angle[i]=frnd()*M_PI+0.7;
            if (i&5) center[i]=center[i-1];
        }
        if ((t>timeS[i])&&(t<timeE[i])) {
            glPushMatrix();
            glTranslatef(center[i][0]+(frnd()*2-1)*0.1,center[i][1]+(frnd()*2-1)*0.1,0);
            glRotatef(speed[i]*t, 0,0,1);
            q=1.0-(t-timeS[i])/(timeE[i]-timeS[i]);
            glColor4f(col[i][0],col[i][1],col[i][2],0.4*q);
            draw_half_circle(r0[i],r1[i],angle[i]);
            glPopMatrix();
        }
    }
}

void fxLines :: draw ()
{
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(45.0, 4.0/3.0, 0.1, 1000.0);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    gluLookAt(0,0,5, 0,0,0, 0,1,0);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    vec3 a,b;
    
    float t =time();
    float x=t*0.0005;
    glPushMatrix();
    for (int i=0; i<NUM_LINES; i++) {
        if (timeE[i]<t) {
            p0[i]=vec3(frnd()*2-1,frnd()*2-1,frnd()*2-1);
            p1[i]=vec3(frnd()*2-1,frnd()*2-1,frnd()*2-1);
            a0[i]=vec3(frnd()*2-1,frnd()*2-1,frnd()*2-1).normalize()*0.01;
            a1[i]=vec3(frnd()*2-1,frnd()*2-1,frnd()*2-1).normalize()*0.01;
            timeS[i]=time()+irnd(100);
            timeE[i]=irnd(300)+100+timeS[i];
        }
        if ((t>timeS[i])&&(t<timeE[i])) {
            a=p0[i]+a0[i]*(t-timeS[i]);
            b=p1[i]+a1[i]*(t-timeS[i]);
            draw_line3d(a,b);
        }
    }
    glPopMatrix();
    glLineWidth(1.0);
    
}

void fxLines :: draw_line3d (vec3& p0, vec3& p1)
{
    vec3 u=(p0-p1)*9000.0;
    vec3 a=p0+u;
    vec3 b=p1-u;
    glColor4f(1,1,1,0.25);
    glLineWidth(3.0);
    glBegin(GL_LINES); glVertex3fv(a.n); glVertex3fv(b.n); glEnd();
    glLineWidth(10.0);
    glColor4f(1,1,1,0.1);
    glBegin(GL_LINES); glVertex3fv(a.n); glVertex3fv(b.n); glEnd();
    /*glLineWidth(15.0);
    glColor4f(1,1,1,0.1);
    glBegin(GL_LINES); glVertex3fv(a.n); glVertex3fv(b.n); glEnd();*/
}

void fxHalfCircles :: draw_half_circle (float r1, float r2, float angle)
{
    #define DIVISION 30
    
    r1=fabs(r1);
    r2=fabs(r2);
    
    float c,s,oldc,olds;
    
    oldc=1.0;
    olds=0.0;
    
    glBegin(GL_QUADS);
    for (int i=1; i<=DIVISION; i++)
    {
        c=cos((angle)/DIVISION*i);
        s=sin((angle)/DIVISION*i);
        
        glVertex2f(oldc*r2, olds*r2);
        glVertex2f(c*r2, s*r2);
        glVertex2f(c*r1, s*r1);
        glVertex2f(oldc*r1, olds*r1);
        
        oldc=c;
        olds=s;
    }
    glEnd();
}

fxEngine f;

void display (void)
{
    glClear(GL_COLOR_BUFFER_BIT);
    glLoadIdentity();
    
    if (LOWORD(BASSMOD_MusicGetPosition())==0) spring.draw();

    f.update();

    float t = time();
    
    if (!fade) {
        DWORD pos=BASSMOD_MusicGetPosition();
        if ((LOWORD(pos)==32)&&(HIWORD(pos)>=40)) {
            fade=true;
            fade_start=t;
        }
    }
    if (fade) {
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        glOrtho(-4,4,-3,3,-1,1);
        glMatrixMode(GL_MODELVIEW);
        glLoadIdentity();
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        float q = 1.0;
        if (t<fade_start+4200.0)
            q=(t-fade_start)/4200.0;
        glColor4f(0,0,0,q*0.5);
        glRectf(-4,-3,4,3);
        
        if (!credit) {
            DWORD pos=BASSMOD_MusicGetPosition();
            if ((LOWORD(pos)==33)&&(HIWORD(pos)>=0)) {
                credit=true;
                credit_start=t;
            }
        }
        if (credit) {
            glEnable(GL_TEXTURE_2D);
            glBlendFunc(GL_SRC_ALPHA, GL_ONE);
            //fade up first label
            q=1.0;
            t-=credit_start;
            
            if (t<8000) q=(t)/8000;
            if (t>8000+3000) q=1.0-(t-(8000+3000))/8000;
            glColor4f(1,1,1,q);
            
            glPushMatrix();
            glTranslatef(t/(8000+3000)-1.1,1,0);
            glScalef(3,3,1);
            glBindTexture(GL_TEXTURE_2D, 4);
            glBegin(GL_QUADS);
            glTexCoord2f(0,0); glVertex2f(-1,1);
            glTexCoord2f(1,0); glVertex2f(1,1);
            glTexCoord2f(1,1); glVertex2f(1,-1);
            glTexCoord2f(0,1); glVertex2f(-1,-1);
            glEnd();
            glPopMatrix();
            
            q=1.0;
            if (t<8000+15000) q=(t-(15000))/8000;
            if (t>8000+15000+3000) q=1.0-(t-(8000+15000+3000))/8000;
            glColor4f(1,1,1,q);
            
            glPushMatrix();
            glTranslatef(1,-0.9+(t-8000-15000)/(8000+3000),0);
            glScalef(3,3,1);
            glBindTexture(GL_TEXTURE_2D, 5);
            glBegin(GL_QUADS);
            glTexCoord2f(0,0); glVertex2f(-1,1);
            glTexCoord2f(1,0); glVertex2f(1,1);
            glTexCoord2f(1,1); glVertex2f(1,-1);
            glTexCoord2f(0,1); glVertex2f(-1,-1);
            glEnd();
            glPopMatrix();

            glDisable(GL_TEXTURE_2D);
            if (BASSMOD_MusicIsActive()==BASS_ACTIVE_STOPPED) running=false;
        }
    } else {  //process fx0
        if (fx0_timeE<t) {
            fx0_timeS=t+frnd()*3000.0;
            fx0_timeE=fx0_timeS+200;
            fx0_alpha=0.2+frnd()*0.5;
        }
        if ((t>fx0_timeS)&&(t<fx0_timeE)) {
            glMatrixMode(GL_PROJECTION);
            glLoadIdentity();
            glOrtho(-4,4,-3,3,-1,1);
            glMatrixMode(GL_MODELVIEW);
            glLoadIdentity();
            glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
            glColor4f(0,0,0,fx0_alpha);
            glRectf(-4,-3,4,3);
        }
                        
    }

    glFlush();
    win.flipBuffers();
}


void initGL (void)
{
    srand(rand() ^ ((LONG)time())*342423423L);

    glClearColor(0,0,0,0);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    //glOrtho(-4,4,-3,3,-1,1);
    gluPerspective(45.0, 4.0/3.0, 0.1, 500.0);
    glMatrixMode(GL_MODELVIEW);
    glEnable(GL_BLEND);
    glEnable(GL_LINE_SMOOTH);
    glHint(GL_LINE_SMOOTH_HINT, GL_DONT_CARE);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    jpeg_loader jpg;
    jpg.load("0.jpg"); jpg.upload(true);
    jpg.load("1.jpg"); jpg.upload(true);
    jpg.load("2.jpg"); jpg.upload(true);
    
    jpg.load("c.jpg"); jpg.upload(true);
    jpg.load("k.jpg"); jpg.upload(true);
}


int main (int argc, char *argv[])
{
    setup();
    if (!demo_run) exit(0);
    
    gl_window_info info;
    info.width=window_width;
    info.height=window_height;
    info.colorDepth=32;
    info.zbufferDepth=16;
    info.fullscreen=!windowed;
    win.open("past mosfncitioo",&info);
    
	initGL();
	BASSMOD_Init(-1,44100,0);
	BASSMOD_MusicLoad(FALSE,musicName,0,0,BASS_MUSIC_RAMPS);
	BASSMOD_MusicPlay();
	//BASSMOD_MusicSetPosition(MAKELONG(16,0));
	while ((win.updateSystem())&&(running)) {
		display();
	}
    BASSMOD_Free(); 
    win.close();
    exit(0); 
}
