/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "scene_manager.h"
#include "../basecode/surface.h"
#include "../basecode/video.h"
#include "../basecode/support.h"
#include "../basecode/music.h"
#include "../basecode/sdl.h"
#include <iostream>
#include <sstream>


using namespace std;

demo::scene::manager::manager(demo::video *v, demo::music *mus)
{
	video = v;
	music = mus;
}

void demo::scene::manager::add(scenebase *sc)
{
	scene[scene.size()] = sc;
}

void demo::scene::manager::runall()
{
	int scene_running = 0;
	second = frametime = timer.get_time();
	frames = 0;
	scenestart = timer.get_time();
	for(;;)
	{
		// Draw scene
		// If the current scene returns 1, switch to the next scene or quit if
		if(scene[scene_running]->draw((timer.get_time() - scenestart), music) == 1)
		// the current scene is the last.
		{
#ifdef DEBUG
			cout << "scene::manager: Scene " << scene_running << " done." << endl;
#endif
			if((unsigned)++scene_running+1 > scene.size())
				demo_shutdown();
			else
				scenestart = timer.get_time();
		}
		// Update video, check for input, show fps
		update();
	}
	
}

void demo::scene::manager::run(int sc)
{
	scenestart = timer.get_time();
	second = frametime = timer.get_time();
	frames = 0;
	
	for(;;)
	{
		// Draw scene
		// If scene returns 1, exit this function.
		if(scene[sc]->draw((timer.get_time() - scenestart), music) == 1)
		{
#ifdef DEBUG
			cout << "scene::manager: Scene " << sc << " done." << endl;
#endif
			break;
		}
		// Update video, check for input, show fps
		update();
	}
}

void demo::scene::manager::update()
{
	video->update();
	update_events();

#ifdef DEBUG
	// Check fps
	if((timer.get_time() - second) > 1000)
	{
		second = timer.get_time();

		if(frames < 25)
		{
			std::string warn;
			std::stringstream times, f;
			f  << frames;

			times << timer.get_time()/1000;

			warn = (std::string) "FPS low (" + f.str()
					+ ") at " + times.str()
					+ " seconds.";
			warning(warn.c_str());
		}
		cout << "FPS: " << frames << endl;

		frames = 0;
	}
	frames++;
#endif
}

void demo::scene::manager::update_events()
{
	// Check for keys or SDL_QUIT
	SDL_Event event;
	SDL_PollEvent(&event);
	if(event.type == SDL_KEYDOWN)
	{
		if(event.key.keysym.sym == SDLK_ESCAPE)
			demo_shutdown();
#ifdef DEBUG
		else if(event.key.keysym.sym == SDLK_SPACE)
			cout << "Space pressed at: " << timer.get_time() - scenestart << endl;	
		else if(event.key.keysym.sym == SDLK_l) {
			cout << "Freeze 2 sec at: " << timer.get_time() - scenestart << endl;
			timer.delay(2000);
		}
#endif
	}
	else if(event.type == SDL_QUIT)
	{
		demo_shutdown();
	}
}
