/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SCENE_INTRO_H
#define SCENE_INTRO_H

#include "../basecode/surface.h"
#include "../gfx/gfx_text.h"
#include "scene.h"
#include "../basecode/global.h"
#include "../basecode/music.h"

namespace demo {
	namespace scene {
		class intro : public scenebase {
		public:
			intro(surface *surface);
			int draw(long time, demo::music *music);
		private:
			void drawimg(pixel *target, pixel *img, int x, int y, int w, int h);
			void drawimg_partwalk(pixel *target, pixel *img, int x, int y,
				int w, int h, int trip, float walk);
			surface *s;
			
			int width;
			int height;
		
			// Text
			demo::gfx::text *text;
		
			// Images
			pixel *xangle3d;
			int xangle3dw, xangle3dh;
		
			pixel *pres;
			int presw, presh;
		
			pixel *scratch;
			int scratchw, scratchh;
		};
	}
}

#endif
