/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "../basecode/surface.h"
#include "../basecode/image.h"
#include "scene_intro.h"
#include <iostream>

using namespace std;

demo::scene::intro::intro(surface *surface)
{
	s = surface;
	width = surface->get_width();
	height = surface->get_height();
	
	// xAngle  
	xangle3d = load_png("../data/textures/xangle3d.png");
	xangle3dw = 319;
	xangle3dh = 134;
	
	// Presents
	pres = load_png("../data/textures/pres.png");
	presw = 256;
	presh = 50;
	
	// Scratch
	scratch = load_png("../data/textures/scratch.png");
	scratchw = 226;
	scratchh = 28;
	
	static demo::gfx::text t(s);
	text = &t;
}




int demo::scene::intro::draw(long time, demo::music *music)
{
	pixel *p = s->lock_rectangle(0).pixels;
	
	for(int y = 0; y < width; y++)
		for(int x = 0; x < height; x++)
			p[x + y * width] = 0;

	int xangle_mx = -(xangle3dw/2) + (width/2);
	int	xangle_my = (int)-(xangle3dh) + (height/2);

	int scratch_mx = -(scratchw/2) + (width/2);
	int	scratch_my = (height/2) + 75;	

		
	static int iy;
	static float ix=0;
	static float ix_amp=1;
	static int retr=0;
	static float save = 0;
	static float ix_c = 0;
	
		
	static bool g0=1, g1=0;
	
	// xAngle
	if(time < 300)
	{
		if(iy <= xangle_my)
			iy = time/(500/xangle_my)*2;
		drawimg(p, xangle3d, xangle_mx, iy, xangle3dw, xangle3dh);
		text->draw("Presents", width/2-(28+7*14)/2, height/2+20);
		//drawimg(p, pres, pres_mx, pres_my+50, presw, presh);
	}
	if(time > 300 && time < 3500)
	{
		drawimg(p, xangle3d, xangle_mx, iy, xangle3dw, xangle3dh);
	
		ix += (time)*0.00015;
		
		/*float move = sin(ix);
		if(move < 0)
			move = -move;*/
		
		
			
		if((time) > 2500)
			ix_amp = 0;
		else
			if(ix_amp >= 0)
				ix_amp -= (time)*0.000009;	
			
		float move = (sin(ix)*ix_amp);
			if(move < 0)
				move = -move;
			
		// Presents
		text->draw("Presents", (width/2-(28+7*14)/2), (height/2+20)+50*move*1.6);
	}
	if(time > 3500 && time < 5000)
	{
		drawimg(p, xangle3d, xangle_mx, iy, xangle3dw, xangle3dh);
		text->draw("Presents", width/2-(28+7*14)/2, height/2+20);
		drawimg(p, scratch, scratch_mx, scratch_my, scratchw, scratchh);
		//save = (time-2500)*0.0032;
	//	drawimg_partwalk(p, scratch, scratch_mx, scratch_my, scratchw, scratchh, 20, save);
	}
	if(time > 5000 && time < 5750)
	{
		drawimg(p, xangle3d, xangle_mx, iy, xangle3dw, xangle3dh);
		text->draw("Presents", width/2-(28+7*14)/2, height/2+20);
		drawimg(p, scratch, scratch_mx, scratch_my, scratchw, scratchh);
//		drawimg_partwalk(p, scratch, scratch_mx, scratch_my, scratchw, scratchh, 20, save);
	}
	if(time > 5750 && time < 7200)
	{
		
		drawimg(p, xangle3d, xangle_mx, iy-((time-5750)*0.4), xangle3dw, xangle3dh);
		//drawimg(p, pres, pres_mx-((time-7000)*0.4), pres_my+50, presw, presh);
		if(time < 5750+200)
			text->draw("Presents", width/2-(28+7*14)/2, height/2+20);
		else if(time < 5750+400)
			text->draw(" resent ", width/2-(28+7*14)/2, height/2+20);
		else if(time < 5750+600)
			text->draw("  esen  ", width/2-(28+7*14)/2, height/2+20);
		else if(time < 5750+800)
			text->draw("   se   ", width/2-(28+7*14)/2, height/2+20);
		drawimg(p, scratch, scratch_mx, scratch_my+((time-5750)*0.4), scratchw,
			scratchh);
	}
	if(time > 7200)
		return 1;

	
	s->unlock_rectangle();
	return 0;
}

void demo::scene::intro::drawimg(pixel *target, pixel *img, int x, int y,
	int w, int h)
{
	for(int i = 0; i < h; i++)
	{
		for(int j = 0; j < w; j++)
		{
			if(!((j+x > width) || (j+x < 0) || (i+y > height) || (i+y < 0)))
				target[j+x + (i+y) * width] = img[j + i * w];
		}
	}		
}

void demo::scene::intro::drawimg_partwalk(pixel *target, pixel *img, int x, int y,
	int w, int h, int trip, float walk)
{
	// Draw forward
	for(int i = 0; i < h; i++)
	{
		for(int j = 0; j < trip*walk; j++)
		{
			if(!((j+x > width) || (j+x < 0) || (i+y > height) || (i+y < 0)))
				target[j+x + (i+y) * width] = img[j + i * w];
		}
	}			
	
	// Draw backward
	/*for(int i = 0; i < h; i++)
	{
		for(int j = w; j > trip*walk; j--)
		{
			if(!((j+x > width) || (j+x < 0) || (i+y > height) || (i+y < 0)))
				target[j+x + (i+y) * width] = img[j + i * w];
		}
	}*/				

}
