/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "scene_end.h"
#include "../basecode/image.h"

demo::scene::end::end(demo::surface *surface)
{
	s = surface;
	theend = load_png("../data/textures/theend.png");
}

int demo::scene::end::draw(long time)
{
	// Just test stuff, not the real endscene
	pixel *p = s->lock_rectangle(0).pixels;
	
	for(int y = 0; y < 480; y++)
		for(int x = 0; x < 640; x++)
			p[x + y * 640] = 0;
	
	for(int y = 0; y < 300; y++)
		for(int x = 0; x < 500; x++)
			p[x + y * 640] = theend[x + y * 500];
	s->unlock_rectangle();
		
	//if(time > 1000)
	//	return 1;
	
	return 0; // 0 = normal, 1 = exit now!
}
