/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GFX_PARTICLES
#define GFX_PARTICLES

#include <map>

#include "../basecode/surface.h"
#include "gfx.h"
#include "../basecode/global.h"

namespace demo
{
	namespace gfx
	{	
		struct particle {
			vector pos;
			vector dir; // Direction and speed 
			color col;
			float life; // Life
		};
		
		class particles
		{
		public:
			particles(demo::surface *surface, int alloc_parts);
			~particles();
			void draw();
			void update();
		private:
			// Surface
			surface *s;
			int width;
			int height;
		
			// Particle
			particle *pe;
			int allocated_parts;
		
			// Emitter
			vector er;
		
			// Gravity
			vector force; // Gravity direction and speed
		
			float rand_irange(float min, float max){return(min+(((float)rand()) 
					/ RAND_MAX)*max); }
		
			float rand_one() // Returns random between 0 and 1
			{
				return (((((float)rand()) / RAND_MAX)*1));
			};

		};
	}
}

#endif
