/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gfx_particles.h"
#include "../basecode/support.h"
#include <sstream>
#include <iostream>

using namespace std;
#if 0
using namespace std;

demo::gfx::particles::particles(demo::surface *surface, int alloc_parts)
{
	s = surface;
	width = surface->get_width();
	height = surface->get_height();
	alloc_parts = 10;
	allocated_parts = alloc_parts;
		
	// Set emit point
	er.x = width/2;
	er.y = height/2;
	er.z = 0;
	
	// Set gravity
	force.x = 0;
	force.y = 0;
	force.z = 0;
	
	// Allocate and setup particles
	pe = new particle[allocated_parts];
	for(int i = 0; i < allocated_parts; i++)
	{
		// Start pos is emit pos
		pe[i].pos.x = er.x;
		pe[i].pos.y = er.y;
		pe[i].pos.z = er.z;
		
		// We start with standing still
		pe[i].dir.x = 0;
		pe[i].dir.y = 0;
		pe[i].dir.z = 0;
		
		// Green is default
		pe[i].col.r = 0;
		pe[i].col.g = 255;
		pe[i].col.b = 0;
		
		// Life time
		pe[i].life = 10 * rand_one();
	}
}

demo::gfx::particles::~particles()
{

}


void demo::gfx::particles::draw()
{
	// Clear
	pixel *p = s->lock_rectangle(0).pixels;
	
	long framelocktime = SDL_GetTicks();
	
	update();
	
	/*for(int i = 0; i < height; i++)
		for(int j = 0; j < width; j++)
			p[j + i*width] = 0;	*/
	
	
	
	for(int i = 0; i < allocated_parts; i++)
	{
		p[(int)((int)pe[i].pos.x + (int)(pe[i].pos.y)*width)] = 255;
	}
	
	

	s->unlock_rectangle();
	while(SDL_GetTicks() - framelocktime < 1000/25) {};	
}

void demo::gfx::particles::update()
{
	float ld = 1.5;
	
	for(int i = 0; i < allocated_parts; i++)
	{
		pe[i].pos.x += pe[i].dir.x * 20;
		pe[i].pos.y += pe[i].dir.y * 20; 
		pe[i].pos.z += pe[i].dir.z * 20;
		pe[i].life -= 0.5;
		
		if(pe[i].life < 0)
		{
			pe[i].pos.x = er.x;
			pe[i].pos.y = er.y;
			float delta = rand_one() * 2 * M_PI;
			pe[i].dir.x = (2 * sin(delta));
			pe[i].dir.y = (2 * cos(delta));
			pe[i].life = 10 * rand_one();
			continue;
		}
	}
}
#endif
