/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GFX_MATRIX
#define GFX_MATRIX

#include "../basecode/surface.h"
#include "../basecode/global.h"

namespace demo
{
	namespace gfx
	{
		typedef struct mstring {
			int *part;
			int len;
			int pos;
		};
		
		typedef struct mline {
			mstring str0;
			mstring str1;
			bool str0_active;
			bool str1_active;
		};
		
		typedef struct mlastline {
			int str0_pos;
			int str1_pos;
		};
			
		class matrix
		{
		public:
			matrix(surface *surface, int maxstrlen);
			~matrix();
			void draw(long runtime, int strips);
		private:
			void draw_letter(pixel *p, int letter, int line, int pos,
				bool header, bool erase);
			void draw_string(pixel *p, mstring *str, int line);
			void draw_black_range(pixel *p, int lastpos, int newpos, int line);
			int rand_letter();
			int rand_stringstart();
			int rand_stringlen();
			int rand_string();
		
			int speed;
		
			// Surface to render to
			surface *s;
			int width;
			int height;
		
			// Matrix letters
			pixel *mx;
		
			// Strings of letters
			int max_stringlen;
			int numstrings; // Number of pregenerated strings
			mstring *str;
			
			// Lines
			mline *line;
			mlastline *lastline;
		};
	}
}

#endif
