/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gfx_matrix.h"
#include "../basecode/surface.h"
#include "../basecode/image.h"
#include <cstdlib>
#include <iostream>

using namespace std;

int demo::gfx::matrix::rand_letter()
{
	return (int)(1+(((float)rand()) / RAND_MAX)*34);
}

int demo::gfx::matrix::rand_stringstart()
{
	return (int)((((float)rand()) / RAND_MAX)*32);
}

int demo::gfx::matrix::rand_stringlen()
{
	return (int)(1+(((float)rand()) / RAND_MAX)*max_stringlen-1);
}

int demo::gfx::matrix::rand_string()
{
	return (int)((((float)rand()) / RAND_MAX)*numstrings);
}

demo::gfx::matrix::matrix(surface *surface, int maxstrlen)
{
	s = surface;

	width = surface->get_width();
	height = surface->get_height();
	
	// Load matrix-font
	
	mx = load_png("../data/textures/matrix-font.png");
	
	// Pregenerate strings
	if(maxstrlen >= 1 && maxstrlen <= 24) // 1 -> screen size
		max_stringlen = maxstrlen;
	else
		max_stringlen = 20;
	
	numstrings = 32*2; // 32 lines * 2 strings

	str = new mstring[numstrings];
	 
	for(int i = 0; i < numstrings; i++)
	{
		str[i].len = rand_stringlen();
		str[i].pos = -str[i].len;
		str[i].part = new int[str[i].len];
		
		// Fill with random letters
		for(int j = 0; j < str[i].len; j++)
			str[i].part[j] = rand_letter();
	}
	
	// Allocate storage for line data
	line = new mline[32];
	for(int i = 0; i < 32; i++)
	{
		line[i].str0_active = false;
		line[i].str1_active = false;
		line[i].str0.part = new int[numstrings];
		line[i].str1.part = new int[numstrings];
	}	
	
	// Allocate storage for last position (used for doing cleanup)
	lastline = new mlastline[32];
}

demo::gfx::matrix::~matrix()
{
	for(int i = 0; i < numstrings; i++)
	{
		delete [] str[i].part;
		delete [] str[i].part;
	}
	delete [] str;
	for(int i = 0; i < 32; i++)
	{
		delete [] line[i].str0.part;
		delete [] line[i].str1.part;
	}
	delete [] line;
	delete [] lastline;
}


void demo::gfx::matrix::draw_letter(pixel *p, int letter, int line, int pos,
	bool header, bool erase)
{
	pixel basecolor;
	// Only draw if in screen
	if(pos >= 0)
	{
		for(int i = 0; i < 20; i++)
		{
			for(int j = 0; j < 20; j++)
			{
				if(!((line*20)+j <= 0) || ((line*20)+j >= width)
					|| ((pos*20)+i <= 0) || ((pos*20)+i >= height))
				{
					if((mx[(letter*20)+j + i*700]>>16) != 0)
						basecolor = (int)(mx[(letter*20)+j + i*700]>>16)<<8;
					else
						basecolor = 0;
				
				// Erase block
				//if(erase)
				//	p[((line*20)+j) + (i+(pos*20))*width] = 0;
				
				// Draw light green
					if(header &&
						basecolor)
					{
						p[((line*20)+j) + (i+(pos*20))*width] =
							(basecolor + (int)150 + (int)(150<<16));
					}
				
				// Draw normal green
					else
						p[((line*20)+j) + (i+(pos*20))*width] = basecolor;
						
				}
			}
		}
	}
}

void demo::gfx::matrix::draw_black_range(pixel *p, int lastpos, int newpos,
	int line)
{
	for(int y = (lastpos*20); y < (newpos*20); y++)
	{
		for(int x = line*20; x < ((line*20)+20); x++){
			p[x + y*width] = 0;
		}
	}
}

void demo::gfx::matrix::draw_string(pixel *p, mstring *str, int line)
{	
	for(int j = 0; j < str->len; j++)
	{
		// If its the first letter, we erase the last one
		if(j == 0)
			draw_letter(p, str->part[j], line, (str->pos)+j-1, false, true);

		// If its the header letter, draw it more bright
		if(j == str->len-1)
				draw_letter(p, str->part[j], line, (str->pos)+j, true, false);
		
		// Else draw normal green
		else
			draw_letter(p, str->part[j], line, (str->pos)+j, false, false);
	}
}

void demo::gfx::matrix::draw(long runtime, int strips)
{
	pixel *p = s->lock_rectangle(0).pixels;
	
	for(int i = 0; i < 32; i++)
	{
		lastline[i].str0_pos = line[i].str0.pos;
		lastline[i].str1_pos = line[i].str1.pos;
		line[i].str0_active = false;
		line[i].str1_active = false;
	}
	srand(5);
	
	
	int rl, rs;
	for(int c = 0; c < runtime/100; c++)
	{
		// String 0 ----------------
		rl = rand_stringstart();
		if(!line[rl].str0_active) {
			rs = rand_string();
		
			// Copy string
			line[rl].str0.len = str[rs].len;
			line[rl].str0.pos = str[rs].pos;
			for(int i = 0; i < 32; i++)
				line[rl].str0.part[i] = str[rs].part[i];
			
			// Set active
			line[rl].str0_active = true;
		}
		
		// String 1 ----------------
		rl = rand_stringstart();
		if(!line[rl].str1_active && (line[rl].str0_active &&
				line[rl].str0.pos > 1))
		{
			int rs = rand_string();
		
			// Copy string
			line[rl].str1.len = str[rs].len;
			for(int i = 0; i < 32; i++)
				line[rl].str1.part[i] = str[rs].part[i];
			
			// Set starting pos
			line[rl].str1.pos = -line[rl].str1.len;
			
			// Set active
			line[rl].str1_active = true;
		}
	
		// Move active strings
		for(int i = 0; i < 32; i++)
		{
			// String 0 ----------------
			if(line[i].str0_active)
			{
				if(line[i].str0.pos == 24)
					line[i].str0_active = false;
				else
					line[i].str0.pos++;
			}			
			// String 1 ----------------
			if(line[i].str1_active)
			{
				if(line[i].str1.pos == 24)
					line[i].str1_active = false;
				else
					line[i].str1.pos++;
			}		
		}
	}
	
	// Cleanup
	/*for(int i = 0; i < 32; i++)
	{
		if((lastline[i].str0_pos >= 0 && line[i].str0.pos > 0)
					&& (lastline[i].str0_pos < line[i].str0.pos-1))
			draw_black_range(p, lastline[i].str0_pos, line[i].str0.pos-1, i);
		if((lastline[i].str1_pos >= 0 && line[i].str1.pos > 0)
					&& (lastline[i].str1_pos < line[i].str1.pos-1))
			draw_black_range(p, lastline[i].str1_pos, line[i].str1.pos-1, i);
		
		draw_black_range(p, 23, 24, i);
	}*/
		
	// Draw
	for(int i = 0; i < strips; i++)
	{
		// String 0 ----------------
		if(line[i].str0_active)
			draw_string(p, &line[i].str0, i);
			
		// String 1 ----------------
		if(line[i].str1_active)
			draw_string(p, &line[i].str1, i);
	}

	s->unlock_rectangle();
	
}
